from collections import namedtuple
from dataclasses import asdict, dataclass, field
from typing import List

SyncFileResult = namedtuple("SyncFileResult", "success project_id file_path detail")
UploadFileResult = namedtuple("UploadFileResult", "success project_id file_path detail")


@dataclass
class ProjectOwner:
    id: str
    type: str
    name: str

    def to_dict(self) -> dict:
        return asdict(self)


@dataclass
class ProjectMetadata:
    user_client: str
    hidden: bool
    tags: List[str] = field(default_factory=list)

    def to_dict(self) -> dict:
        return asdict(self)
