from dataclasses import dataclass
from typing import Dict, List, Optional

from aext_project_filebrowser_server.exceptions import FailedToInstantiateSchema

from aext_shared.logger import logger


@dataclass
class OrganizationMember:
    id: str
    email: str
    first_name: str
    last_name: str
    role: str
    subscriptions: [str]
    groups: Optional[List[str]] = None


@dataclass
class OrganizationMembers:
    members: List[OrganizationMember]

    @classmethod
    def create_from_cloud_response(cls, cloud_response: Dict) -> "OrganizationMembers":
        try:
            return cls(members=[OrganizationMember(**item) for item in cloud_response["items"]])
        except Exception as ex:
            logger.error("Failed to create OrganizationMembers from cloud response")
            raise FailedToInstantiateSchema from ex

    def get_member(self, user_id: str) -> OrganizationMember:
        for member in self.members:
            if member.id == user_id:
                return member
