import sys
from unittest import mock

import pytest
import tornado
from aext_project_filebrowser_server.clients.http import ProjectAPIClientHTTP
from aext_project_filebrowser_server.consts import UNDEFINED_ENVIRONMENT
from aext_project_filebrowser_server.schemas.cloud_project import CloudProject
from aext_project_filebrowser_server.schemas.local_project import LocalProject
from aext_project_filebrowser_server.services.projects import ProjectService
from tests.setup_tests import BasicDBAppHTTPTests
from tests.test_assets.project_data import CLOUD_PROJECT

pytestmark = pytest.mark.skipif(sys.platform.startswith("win"), reason="Skipping tests on Windows")


class CreateProject(BasicDBAppHTTPTests):
    def setUp(self):
        self.project_service = ProjectService()
        self.project_service.client = ProjectAPIClientHTTP()
        return super().setUp()

    def tearDown(self):
        return super().tearDown()

    @tornado.testing.gen_test
    @mock.patch("aext_project_filebrowser_server.clients.http.ProjectAPIClientHTTP.create_project")
    async def test_created_project_has_set_tags(self, mock_client_create_project):
        tags = ["an-amazing-tag", "a-less-amazing-tag"]

        cloud_project_data = CLOUD_PROJECT
        cloud_project_data["metadata"]["tags"] = tags
        mock_client_create_project.return_value = CloudProject.create(cloud_project_data)

        project_title = "test-project"
        project_default_environment = UNDEFINED_ENVIRONMENT

        project = await self.project_service.create_project(project_title, project_default_environment, tags)
        project_tags = project.get_tags()

        for tag in project_tags:
            assert tag in tags

        assert len(project_tags) == len(tags)

    @tornado.testing.gen_test
    @mock.patch("aext_project_filebrowser_server.clients.http.ProjectAPIClientHTTP.create_project")
    async def test_created_project_with_a_conda_environments(self, mock_client_create_project):
        tags = ["data", "notebook"]
        cloud_project_data = CLOUD_PROJECT
        cloud_project_data["metadata"]["tags"] = tags
        mock_client_create_project.return_value = CloudProject.create(cloud_project_data)

        project_title = "test-project"
        project_default_environment = UNDEFINED_ENVIRONMENT

        project = await self.project_service.create_project(project_title, project_default_environment, tags)
        self.assertEqual(project.default_environment, UNDEFINED_ENVIRONMENT)
