import os
from unittest import mock

import pytest


@pytest.fixture(scope="module", autouse=True)
def mock_send_metric():
    with mock.patch("aext_project_filebrowser_server.metrics.FileBrowserSnakeEyes.send") as m:
        yield m


@pytest.fixture(scope="module", autouse=True)
def mock_authenticate_project_service():
    with mock.patch(
        "aext_project_filebrowser_server.handlers.ProjectFileBrowserHandler.authenticate_project_service"
    ) as m:
        m.return_value = {
            "refresh_token": "user-refresh-token",
            "access_token": "user-access-token",
            "api_key": "user-api-key",
            "username": "username",
        }
        yield m
