"""change_id_type_from_int_to_str

Revision ID: de8ce1570882
Revises: a4d46f4a8a45
Create Date: 2024-04-16 14:18:43.398872

"""

from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "de8ce1570882"
down_revision: Union[str, None] = "a4d46f4a8a45"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # SQLite does not accept altering tables to add constraints, therefore a multiple step migration approach is necessary.

    ######################################################################################
    # This migration fixes an error in the first one which created the ID as Integer,
    # instead it should be originally a String
    ######################################################################################

    # Create a temporary table with the desired schema
    op.create_table(
        "temp_projects",
        sa.Column("id", sa.String, primary_key=True),
        sa.Column("data", sa.TEXT(), nullable=True),
        sa.Column("owner", sa.TEXT(), nullable=True),
        sa.Column("name", sa.TEXT(), nullable=True),
        sa.UniqueConstraint("owner", "name", name="uq_owner_name_temp"),
    )

    # Copy data from the original table to the temporary table
    op.execute(
        "INSERT INTO temp_projects (id, data, owner, name) SELECT CAST(id AS VARCHAR), data, owner, name FROM projects"
    )

    # Drop the original table
    op.drop_table("projects")

    # Rename the temporary table to the original table name
    op.rename_table("temp_projects", "projects")


def downgrade() -> None:
    # Create a temporary table with the original schema
    op.create_table(
        "temp_projects",
        sa.Column("id", sa.Integer, primary_key=True),
        sa.Column("data", sa.TEXT(), nullable=True),
        sa.Column("owner", sa.TEXT(), nullable=True),
        sa.Column("name", sa.TEXT(), nullable=True),
        sa.UniqueConstraint("owner", "name", name="uq_owner_name_temp"),
    )

    # Copy data from the modified table to the temporary table
    op.execute(
        "INSERT INTO temp_projects (id, data, owner, name) SELECT CAST(id AS INTEGER), data, owner, name FROM projects"
    )

    # Drop the modified table
    op.drop_table("projects")

    # Rename the temporary table to the original table name
    op.rename_table("temp_projects", "projects")
