# -*- coding: utf-8 -*-

# pylint: disable=import-outside-toplevel,missing-function-docstring

"""Tests for login dialog."""

from __future__ import annotations

__all__ = ()

import json
from unittest import mock


TEST_CHANNELS = {
    'total_count': 1,
    'items': [
        {'id': '1df63-4c1-44-af0f-027308381',
         'name': 'testing_channel',
         'description': '',
         'privacy': 'public',
         'artifact_count': 2,
         'download_count': 1,
         'subchannel_count': 0,
         'group_count': 1,
         'mirror_count': 0,
         'filters': {},
         'owners': ['test_user'],
         'created': '2021-02-17T16:05:34.521373+00:00',
         'updated': None}
    ]
}


def test_get_channels():
    from anaconda_navigator.api.team_edition_api import api as team_edition_api

    token = {
        'token': 'iOiJSUzI1NiIsInR5cCIgOiAiSldUIiIiA6ICI2eTRpaVhkWXl3eC0wQUlWeVAyTlA5OWd6bWhtRUVOVmZ2M2',
        'refresh_token': 'eyiIsInR5cIiwia2lkIiA6ICJhOTMxNTYxYi05NDY4LTRhNTAtOTBlZS1iNDAxY',
        'jwt_token': 'eOiJSUzI1NiIsInR5cCIgOiAiSldUIiA6ICI2eTRpaVhkWXl3eC0wQUlWeVAyTlA5OWd6bWhtRUVOV',
        'jwt_token_refresh': 'hbGciOJIUzI1NiIsInR5cCIlkIiA6ICJhOTMxNTYxYi05NDY4LTRhNTAtOTBlZS1iN'
    }

    api = team_edition_api.TeamEditionAPI('https://ate.testing.base.mock', mock.Mock())
    api.load_token = mock.Mock(return_value=json.dumps(token))

    mock_response = mock.Mock()
    mock_response.json.return_value = TEST_CHANNELS

    team_edition_api.requests = mock.Mock()  # pylint: disable=assigning-non-slot
    team_edition_api.requests.request.return_value = mock_response

    assert api.get_channels() == TEST_CHANNELS['items']
    assert api.get_channels() == TEST_CHANNELS['items']
