# -*- coding: utf-8 -*-

# pylint: disable=import-outside-toplevel

# -----------------------------------------------------------------------------
# Copyright (c) 2016-2017 Anaconda, Inc.
#
# May be copied and distributed freely only as part of an Anaconda or
# Miniconda installation.
# -----------------------------------------------------------------------------

"""Tests for Cache class."""

from __future__ import annotations

__all__ = ()

import typing

import pytest

if typing.TYPE_CHECKING:
    from anaconda_navigator.utils.attribution import resources as t_resources


@pytest.fixture(scope='function')
def cache_instance(temporary_folder: str) -> typing.Iterator['t_resources.Cache']:
    """Prepare new :class:`~anaconda_navigator.widgets.attribution.resources.Cache` instance for tests."""
    from anaconda_navigator.utils.attribution import resources
    yield resources.Cache(root=temporary_folder)


def test_cache_store(cache_instance: 't_resources.Cache') -> None:  # pylint: disable=redefined-outer-name
    """Test store cache into file"""
    first_key: typing.Final[str] = 'https://some_test_name.com/strange_place'
    second_key: typing.Final[str] = 'https://does_not_exist.com'

    assert cache_instance.get(first_key) is None
    assert cache_instance.get(second_key) is None

    first_data: typing.Final[bytes] = b'test bytes data'
    cache_instance.store(first_key, first_data)
    assert cache_instance.get(first_key) == first_data
    assert cache_instance.get(second_key) is None

    second_data: typing.Final[bytes] = b'some changed bytes data'
    cache_instance.store(first_key, second_data)
    assert cache_instance.get(first_key) == second_data
    assert cache_instance.get(second_key) is None

    third_data: typing.Final[bytes] = b'another test'
    cache_instance.store(second_key, third_data)
    assert cache_instance.get(first_key) == second_data
    assert cache_instance.get(second_key) == third_data
