# -*- coding: utf-8 -*-

# pylint: disable=import-outside-toplevel,missing-function-docstring

# -----------------------------------------------------------------------------
# Copyright (c) 2016-2017 Anaconda, Inc.
#
# May be copied and distributed freely only as part of an Anaconda or
# Miniconda installation.
# -----------------------------------------------------------------------------

"""Tests the about dialog."""

from __future__ import annotations

__all__ = ()

import pytest
from qtpy.QtCore import Qt
from tests.current.widgets import common_extra


@pytest.fixture()
def about_dialog(qtbot, qt_styles):  # pylint: disable=unused-argument
    from anaconda_navigator.widgets.dialogs import about as dialogs_about

    widget = dialogs_about.AboutDialog()
    qtbot.addWidget(widget)
    widget.show()

    return common_extra.BotContext(qtbot=qtbot, widget=widget)


def test_ok(about_dialog):  # pylint: disable=redefined-outer-name
    with about_dialog.qtbot.waitSignal(about_dialog.widget.accepted, timeout=1000, raising=True):
        about_dialog.qtbot.mouseClick(about_dialog.widget.button_ok, Qt.LeftButton)


def test_cancel(about_dialog):  # pylint: disable=redefined-outer-name
    with about_dialog.qtbot.waitSignal(about_dialog.widget.rejected, timeout=1000, raising=True):
        about_dialog.qtbot.keyPress(about_dialog.widget, Qt.Key_Escape)


def test_link(about_dialog):  # pylint: disable=redefined-outer-name
    with about_dialog.qtbot.waitSignal(about_dialog.widget.sig_url_clicked, timeout=1000, raising=True):
        about_dialog.qtbot.mouseClick(about_dialog.widget.button_link, Qt.LeftButton)
