# -*- coding: utf-8 -*-

# pylint: disable=import-outside-toplevel,missing-function-docstring

# -----------------------------------------------------------------------------
# Copyright (c) 2016-2017 Anaconda, Inc.
#
# May be copied and distributed freely only as part of an Anaconda or
# Miniconda installation.
# -----------------------------------------------------------------------------

"""Tests for quit-like dialogs."""

from __future__ import annotations

__all__ = ()

import pytest
from qtpy.QtCore import Qt, QTimer, QCoreApplication  # pylint: disable=no-name-in-module
from tests.current.widgets import common_extra

TEST_USER = 'testuser'

QCoreApplication.setAttribute(Qt.AA_UseSoftwareOpenGL)
QCoreApplication.setAttribute(Qt.AA_ShareOpenGLContexts)


def prepare_config():
    from anaconda_navigator import config as navigator_config

    navigator_config.CONF.set('internal', 'anaconda_toolbox_installed', True)
    navigator_config.CONF.set('internal', 'cloud_login_popup_state', 0)
    navigator_config.CONF.set('main', 'hide_quit_dialog', True)
    navigator_config.CONF.set('main', 'hide_update_dialog', True)
    navigator_config.CONF.set('main', 'launch_darkly_proxy_url', '')
    navigator_config.CONF.set('main', 'hide_whats_new_dialog', True)


@pytest.fixture(scope='function')
def botmain(qtbot, qt_styles):  # pylint: disable=unused-argument
    from anaconda_navigator.widgets import main_window

    prepare_config()
    widget = main_window.MainWindow()
    qtbot.addWidget(widget)
    widget.showMaximized()
    return common_extra.BotContext(qtbot=qtbot, widget=widget)


def test_all(botmain):  # pylint: disable=redefined-outer-name
    with botmain.qtbot.waitSignal(botmain.widget.sig_ready, timeout=60_000, raising=True):
        botmain.widget.showMaximized()


def test_geo_save(botmain):  # pylint: disable=redefined-outer-name
    from anaconda_navigator import config as navigator_config

    with botmain.qtbot.waitSignal(botmain.widget.sig_ready, timeout=60_000, raising=True):
        pass
    botmain.widget.close()
    assert navigator_config.CONF.get('main', 'geo')


def test_dialog_about(botmain):  # pylint: disable=redefined-outer-name
    def _interact():
        dlg = botmain.widget._dialog_about  # pylint: disable=protected-access
        dlg.accept()

    with botmain.qtbot.waitSignal(botmain.widget.sig_ready, timeout=60_000, raising=True):
        pass

    timer = QTimer()
    timer.setInterval(5000)
    timer.timeout.connect(_interact)
    timer.start()
    botmain.widget.show_about()


def test_dialog_channels(botmain):  # pylint: disable=redefined-outer-name
    def _interact():
        dlg = botmain.widget._dialog_channels  # pylint: disable=protected-access
        dlg.reject()

    with botmain.qtbot.waitSignal(botmain.widget.sig_ready, timeout=60_000, raising=True):
        pass
    timer = QTimer()
    timer.setInterval(5000)
    timer.timeout.connect(_interact)
    timer.start()
    botmain.qtbot.mouseClick(botmain.widget.tab_home.button_channels, Qt.LeftButton)


def test_dialog_logs(botmain):  # pylint: disable=redefined-outer-name
    def _interact():
        dlg = botmain.widget._dialog_logs  # pylint: disable=protected-access
        dlg.accept()

    with botmain.qtbot.waitSignal(botmain.widget.sig_ready, timeout=60_000, raising=True):
        pass
    timer = QTimer()
    timer.setInterval(10000)
    timer.timeout.connect(_interact)
    timer.start()
    botmain.widget.show_log_viewer()


def test_dialog_preferences(botmain):  # pylint: disable=redefined-outer-name
    def _interact():
        dlg = botmain.widget._dialog_preferences  # pylint: disable=protected-access
        dlg.reject()

    with botmain.qtbot.waitSignal(botmain.widget.sig_ready, timeout=60_000, raising=True):
        pass
    timer = QTimer()
    timer.setInterval(5000)
    timer.timeout.connect(_interact)
    timer.start()
    botmain.widget.show_preferences()
