# -*- coding: utf-8 -*-

# -----------------------------------------------------------------------------
# Copyright (c) 2016-2017 Anaconda, Inc.
#
# May be copied and distributed freely only as part of an Anaconda or
# Miniconda installation.
# -----------------------------------------------------------------------------

"""This folder contains css for QSS styling of the application."""

from __future__ import annotations

__all__ = ['DATA_PATH', 'DARK_MODE_STYLES_PATH', 'GLOBAL_SASS_STYLES_PATH', 'LIGHT_MODE_STYLES_PATH']

import typing

import os.path as osp


DATA_PATH = osp.dirname(osp.realpath(__file__))
DARK_MODE_STYLES_PATH = osp.join(DATA_PATH,  'dark.css')
GLOBAL_SASS_STYLES_PATH = osp.join(DATA_PATH, 'styles.scss')
LIGHT_MODE_STYLES_PATH = osp.join(DATA_PATH, 'light.css')
