# -*- coding: utf-8 -*-

# -----------------------------------------------------------------------------
# Copyright (c) 2016-2017 Anaconda, Inc.
#
# May be copied and distributed freely only as part of an Anaconda or
# Miniconda installation.
# -----------------------------------------------------------------------------

"""
This folder contains image files bundled with Anaconda Navigator package.

This folder is defined as a python module so that some convenience global
variables can be defined.
"""

from __future__ import annotations

__all__ = ()

import os
import shutil
import tempfile


LIGHT_IMAGE_PATH = os.path.join(os.path.dirname(os.path.realpath(__file__)), 'light')
DARK_IMAGE_PATH = os.path.join(os.path.dirname(os.path.realpath(__file__)), 'dark')
IMAGE_PATH = os.path.join(os.path.dirname(os.path.realpath(__file__)), 'common')

LOGO_PATH = os.path.join(IMAGE_PATH, 'logos')

APPLICATIONS_PATH = os.path.join(IMAGE_PATH, 'applications')
ICONS_PATH = os.path.join(IMAGE_PATH, 'icons')
STYLED_ICON_TEMPLATES_PATH = os.path.join(IMAGE_PATH, 'icons', 'common')
STYLED_ICONS_PATH = tempfile.mkdtemp()

# -----------------------------------------------------------------------------
ANACONDA_ICON_256_PATH = os.path.join(IMAGE_PATH, 'anaconda-icon-256x256.png')
BLOCK_CLOSE_ICON_PATH = os.path.join(ICONS_PATH, 'block-close.svg')


def cleanup() -> None:
    """Remove temp image folders."""
    shutil.rmtree(STYLED_ICONS_PATH, ignore_errors=True)
