"""Set of utils to work with :mod:`repo_cli`."""
from __future__ import annotations

import logging
from argparse import Namespace

from repo_cli.commands.base import SubCommandBase
from repo_cli.commands.login import SubCommand
from repo_cli.utils.api import RepoApi


class RepoCliCore:  # pylint: disable=too-few-public-methods
    """Mocked base class used by :mod:`repo_cli` commands"""
    def __init__(self, url, verify_ssl=True):
        self.args = Namespace(force_scopes=False)
        self.verify_ssl = verify_ssl
        self.url = url
        self._access_token = None
        self.api = RepoApi(
            base_url=self.url, user_token=self._access_token, verify_ssl=self.verify_ssl
        )
        self.api._access_token = self._access_token
        self.log = logging.getLogger(__name__)


def get_login_command(base_url: str, verify_ssl: bool | str) -> SubCommand:
    """Return a new instance :class:`repo_cli.commands.login.SubCommand`."""
    return SubCommand(SubCommandBase(RepoCliCore(base_url, verify_ssl)))
