"""Common helpers for widget signals."""

__all__ = ['DialogOutcome', 'DialogValue']

import enum


class DialogOutcome(enum.Enum):
    """Options for dialog result."""
    REJECT = enum.auto()
    DIALOG_REQUEST = enum.auto()


class DialogValue(enum.Enum):
    """Options for dialog value, that can be selected in the dialog."""

    LOGIN_REMINDER = enum.auto()
    REPO_SELECTOR = enum.auto()
