# -*- coding: utf-8 -*-

"""
Tests for interfaces of internal Navigator components.

As an example of what might be tested with such tests - any internal components with usable API interfaces (like
workers, caching components, etc.). Components with user interfaces might also be checked here (dialogs, windows,
separate reusable widgets).

Such tests should have simple but completed scenarios. If there is any step in testing scenario that is unnecessary
for the test result goal - it is advised to move it into a separate test. In some cases it may allow better detection
of an actual issue causes.

.. warning::

    Each test runs in an isolated context. This means state is not shared between tests. E.g. if one test logs into some
    account (stores credentials in variable or file), second test would still have no access to such values and should
    log into account individually.

    If you need the same account details - you can use fixtures to share same login process between tests.

When you don't want a component test
====================================

If any component requires any external connection (web api or external application call) - either these should be
mocked, or it should be an integration test instead of component test.

Where to put tests
==================

All component tests should be located in :mod:`~tests/component_tests` package. For each component there should be
either a file or a package with tests (depending on how many tests required for each package). Thus, you should have
something like:

- :code:`tests/component_tests/test_small_component.py`
- :code:`tests/component_tests/test_big_component/test_generators.py`
- :code:`tests/component_tests/test_big_component/test_parsers.py`

Each separate test should have a distinctive name that should be enough to understand the primary goal of a test
(e.g. `test_document_update`).
"""
