# -*- coding: utf-8 -*-

# pylint: disable=import-outside-toplevel

"""Common configuration for tests."""

from __future__ import annotations

__all__ = ()

import typing

import pytest
from qtpy import QtCore

if typing.TYPE_CHECKING:
    from anaconda_navigator.widgets.main_window import account_components
    from tests.mocks import cloud_api


QtCore.QCoreApplication.setAttribute(QtCore.Qt.AA_UseSoftwareOpenGL)
QtCore.QCoreApplication.setAttribute(QtCore.Qt.AA_ShareOpenGLContexts)


@pytest.fixture(scope='function')
def base_accounts_component(
        mocked_cloud_api: 'cloud_api.Control',  # pylint: disable=unused-argument
        synchronous_workers: None,  # pylint: disable=unused-argument
) -> typing.Iterator['account_components.AccountsComponent']:
    """Prepare instance of :class:`~anaconda_navigator.widgets.main_window.account_components.AccountsComponent`."""
    from anaconda_navigator.api import anaconda_api

    from anaconda_navigator.widgets.main_window import account_components

    class MainWindow(QtCore.QObject):  # pylint: disable=too-few-public-methods
        """Fake :class:`~anaconda_navigator.widgets.main_window.MainWindow` instance."""

        def __init__(self) -> None:
            """Initialize new :class:`~MainWindow` instance."""
            super().__init__()

            self.api = anaconda_api.AnacondaAPI()

        def open_url(
                self,
                url: str,
                category: typing.Optional[str] = None,
                action: typing.Optional[str] = None,
        ) -> None:
            """Open url and track event."""

        def update_status(
                self,
                action: str = '',
                message: str = '',
                value: int | None = None,
                max_value: int | None = None
        ) -> None:
            """Update the status and progress bar of the widget."""

    yield account_components.AccountsComponent(parent=MainWindow())
