# -*- coding: utf-8 -*-

# pylint: disable=import-outside-toplevel,missing-function-docstring,missing-module-docstring

from __future__ import annotations

__all__ = ()

from unittest import mock
import pytest


def dialog_bot(request, qtbot, widget):
    widget.api = mock.Mock()
    request.cls.qtbot = qtbot
    request.cls.widget = widget

    qtbot.addWidget(widget)
    widget.show()


@pytest.fixture(scope='function')
def anaconda_org_dialog_bot(request, qtbot, qt_styles):  # pylint: disable=unused-argument
    from anaconda_navigator.widgets.dialogs import login as login_dialogs

    return dialog_bot(request, qtbot, login_dialogs.AnacondaLoginPage())


@pytest.fixture(scope='function')
def commercial_dialog_bot(request, qtbot, qt_styles):  # pylint: disable=unused-argument
    from anaconda_navigator.widgets.dialogs import login as login_dialogs

    return dialog_bot(request, qtbot, login_dialogs.CommercialEditionLoginPage())


@pytest.fixture(scope='function')
def enterprise_domain_set_dialog_bot(request, qtbot, qt_styles):  # pylint: disable=unused-argument
    from anaconda_navigator.widgets.dialogs import login as login_dialogs

    return dialog_bot(request, qtbot, login_dialogs.EnterpriseRepoSetDomainPage())


@pytest.fixture(scope='function')
def enterprise_login_page_dialog_bot(request, qtbot, qt_styles):  # pylint: disable=unused-argument
    from anaconda_navigator.widgets.dialogs import login as login_dialogs

    request.cls.config_url_option = 'anaconda_api_url'
    return dialog_bot(request, qtbot, login_dialogs.EnterpriseRepoLoginPage())


@pytest.fixture(scope='function')
def team_domain_set_dialog_bot(request, qtbot, qt_styles):  # pylint: disable=unused-argument
    from anaconda_navigator.widgets.dialogs import login as login_dialogs

    return dialog_bot(request, qtbot, login_dialogs.TeamEditionSetDomainPage())


@pytest.fixture(scope='function')
def team_login_page_dialog_bot(request, qtbot, qt_styles):  # pylint: disable=unused-argument
    from anaconda_navigator.widgets.dialogs import login as login_dialogs

    return dialog_bot(request, qtbot, login_dialogs.TeamEditionLoginPage())


@pytest.fixture(scope='function')
def team_add_channels_page_dialog_bot(request, qtbot, qt_styles):  # pylint: disable=unused-argument
    from anaconda_navigator.widgets.dialogs import login as login_dialogs

    anaconda_api_mock = mock.Mock()
    anaconda_api_mock.get_channels.return_value = tuple()
    return dialog_bot(request, qtbot, login_dialogs.TeamEditionAddChannelsPage())


@pytest.fixture(scope='function')
def notice_page_dialog_bot(request, qtbot, qt_styles):  # pylint: disable=unused-argument
    from anaconda_navigator.widgets.dialogs import login as login_dialogs

    return dialog_bot(request, qtbot, login_dialogs.NoticePage())
