# -*- coding: utf-8 -*-

# pylint: disable=import-outside-toplevel,missing-function-docstring,missing-module-docstring

from __future__ import annotations

__all__ = ()

import typing
from unittest import mock
from qtpy.QtCore import Qt


class TestBaseLoginPage:  # pylint: disable=missing-class-docstring

    qtbot: typing.Any
    widget: typing.Any

    def test_login_button_enabled(self):
        self.qtbot.wait_for_window_shown(self.widget)

        self.widget.text_login.setText('TEST_USER')
        self.widget.text_password.setText('TEST_PASSWORD')
        self.widget.text_login.textEdited.emit(None)
        assert self.widget.button_login.isEnabled() is True

        self.widget.text_login.setText('')
        self.widget.text_password.setText('')
        self.widget.text_login.textEdited.emit(None)
        assert self.widget.button_login.isEnabled() is False

    def test_login(self):
        from anaconda_navigator import config as navigator_config

        self.qtbot.wait_for_window_shown(self.widget)

        self.widget.text_login.setText('TEST_USER')
        self.widget.text_password.setText('TEST_PASSWORD')
        self.widget.text_login.textEdited.emit(None)

        with \
                mock.patch.object(navigator_config.CONF, 'get'), \
                self.qtbot.wait_signal(self.widget.button_login.clicked, raising=True):

            navigator_config.CONF.get.return_value = 'https://api.anaconda.org'
            self.widget.api.login.return_value = mock.Mock()
            self.qtbot.wait(1500)
            self.qtbot.mouseClick(self.widget.button_login, Qt.LeftButton)
            self.widget.api.client_reload.assert_called()

    def test_login_finished(self):
        worker, output, error = mock.Mock(), 'TOKEN_MOCK', ''
        self.widget._finished(worker, output, error)  # pylint: disable=protected-access
        with mock.patch.object(self.widget, 'accept'):
            self.widget.accept.assset_called()

    def test_login_finished_with_error(self):
        worker, output, error = mock.Mock(), '', 'error'
        self.widget._finished(worker, output, error)  # pylint: disable=protected-access
        with mock.patch.object(self.widget, 'accept'):
            self.widget.accept.assset_not_called()


class TestBaseSetDomainPage:  # pylint: disable=missing-class-docstring

    qtbot: typing.Any
    widget: typing.Any

    def test_set_domain(self):
        from anaconda_navigator import config as navigator_config

        domain = 'https://api.someedition.com'
        self.widget.input_line.setText(domain)

        with \
                mock.patch.object(self.widget, 'check_text'), \
                mock.patch.object(self.widget, 'accept'), \
                mock.patch.object(self.widget, 'api'), \
                mock.patch.object(navigator_config.CONF, 'set'), \
                self.qtbot.wait_signal(self.widget.button_apply.clicked, raising=True):

            self.widget.check_text.return_value = True
            self.qtbot.mouseClick(self.widget.button_apply, Qt.LeftButton)
            self.widget.accept.assert_called()
            self.widget.check_text.assert_called()
            self.widget.api.client_reload.assert_called()
            navigator_config.CONF.set.assert_called()  # pylint: disable=no-member

    def test_set_domain_failed(self):
        from anaconda_navigator import config as navigator_config

        with \
                mock.patch.object(self.widget, 'check_text'), \
                mock.patch.object(self.widget, 'accept'), \
                mock.patch.object(self.widget, 'api'), \
                mock.patch.object(navigator_config.CONF, 'set'), \
                self.qtbot.wait_signal(self.widget.button_apply.clicked, raising=True):

            self.widget.check_text.return_value = False
            self.qtbot.mouseClick(self.widget.button_apply, Qt.LeftButton)
            self.widget.check_text.assert_called()
            self.widget.accept.assert_not_called()
            self.widget.api.client_reload.assert_not_called()
            navigator_config.CONF.set.assert_not_called()  # pylint: disable=no-member
