# -*- coding: utf-8 -*-

# pylint: disable=import-outside-toplevel,missing-function-docstring

# -----------------------------------------------------------------------------
# Copyright (c) 2016-2017 Anaconda, Inc.
#
# May be copied and distributed freely only as part of an Anaconda or
# Miniconda installation.
# -----------------------------------------------------------------------------

"""Tests for environments tab."""

from __future__ import annotations

__all__ = ()

import pytest
from qtpy.QtCore import Qt
from tests.current.widgets import common_extra


@pytest.fixture(scope='function')
def env_tab(qtbot, qt_styles):  # pylint: disable=unused-argument
    from anaconda_navigator.widgets.tabs import environments as tabs_environments

    widget = tabs_environments.EnvironmentsTab()
    qtbot.addWidget(widget)
    widget.show()
    widget.setup_tab(metadata={})
    widget.load_environment()

    return common_extra.BotContext(qtbot=qtbot, widget=widget)


def package_version(pkg, name='root'):
    from anaconda_navigator.api import conda_api

    api = conda_api.CondaAPI()
    return api.package_version(name=name, pkg=pkg, build=True)


def remove_env(widget):
    worker = widget.packages_widget.remove_environment(name='navigatortest')
    worker.communicate()  # run create


@pytest.mark.xfail
def test_bad_create(env_tab, temporary_file):  # pylint: disable=redefined-outer-name
    from anaconda_navigator.widgets import dialogs

    dialogs.MessageBoxError.exec_ = lambda *args: True

    with open(temporary_file, 'w', encoding='utf-8') as stream:
        stream.write('name: navigatortest\ndependencies:\n- not-real=0.0.0=py36_0')

    worker = env_tab.widget.packages_widget.import_yaml(name='navigatortest', yaml=temporary_file)

    with env_tab.qtbot.waitSignal(env_tab.widget.sig_error_popped_up, timeout=5000):
        with env_tab.qtbot.waitSignal(worker.sig_finished, timeout=5000):
            worker.name = 'navigatortest'
            worker.sig_finished.connect(env_tab.widget._environment_created)  # pylint: disable=protected-access


@pytest.mark.xfail
def test_ipython_option(env_tab):  # pylint: disable=redefined-outer-name
    from anaconda_navigator.widgets import dialogs

    dialogs.MessageBoxError.exec_ = lambda *args: True

    pyver = f'python={package_version("python")}'

    remove_env(env_tab.widget)
    worker = env_tab.widget.packages_widget.create_environment(name='navigatortest', packages=[pyver])
    worker.name = 'navigatortest'
    worker.communicate()  # run create
    env_tab.widget._environment_created(worker, '', '')  # pylint: disable=protected-access
    env_tab.widget.menu_list.exec_ = lambda *args: True
    env_tab.qtbot.mouseClick(env_tab.widget.list_environments.currentItem().button_options, Qt.LeftButton)
    is_action_enabled = env_tab.widget.menu_list.actions()[2].isEnabled()
    assert not is_action_enabled

    worker = env_tab.widget.packages_widget.api.conda_install(name='navigatortest', pkgs=['jupyter-core'])
    worker.communicate()
    env_tab.qtbot.mouseClick(env_tab.widget.list_environments.currentItem().button_options, Qt.LeftButton)
    assert not env_tab.widget.menu_list.actions()[2].isEnabled()

    worker = env_tab.widget.packages_widget.api.conda_install(name='navigatortest', pkgs=['ipython'])
    worker.communicate()
    env_tab.qtbot.mouseClick(env_tab.widget.list_environments.currentItem().button_options, Qt.LeftButton)
    assert env_tab.widget.menu_list.actions()[2].isEnabled()

    worker = env_tab.widget.packages_widget.remove_environment(name='navigatortest')
    worker.communicate()  # run create

    remove_env(env_tab.widget)
