# -*- coding: utf-8 -*-

# pylint: disable=import-outside-toplevel

"""Additional utilities for :mod:`~anaconda_navigator.utils.workers` testing."""

from __future__ import annotations

__all__ = ['patch_synchronous']

import typing

if typing.TYPE_CHECKING:
    from anaconda_navigator.utils import workers


def patch_synchronous(task: 'workers.Task') -> 'workers.Task':
    """Update task to generate synchronous workers."""
    from anaconda_navigator.utils import workers

    class SynchronousTask(workers.Task):
        """Custom task which prepares synchronous workers."""

        def worker(self, *args: typing.Any, **kwargs: typing.Any) -> workers.TaskWorker:
            """Prepare worker to execute this task."""
            result: 'workers.TaskWorker' = super().worker(*args, **kwargs)
            result.start = result.run  # type: ignore
            return result

    return SynchronousTask(task.function, *task.modifiers)
