# -*- coding: utf-8 -*-

# pylint: disable=import-outside-toplevel

"""Validate URLs from Navigator preferences."""

from __future__ import annotations

__all__ = ()

import pytest
import requests


def test_sidebar_urls() -> None:
    """Check URLs used for the sidebar."""
    from anaconda_navigator.config import preferences

    urls: set[str] = set()
    urls.update(item.url for item in preferences.SIDEBAR_LINKS)
    urls.update(item.url for item in preferences.SIDEBAR_SOCIALS)

    failed: list[str] = []
    suspicious: list[str] = []

    url: str
    for url in urls:
        try:
            response: requests.Response = requests.get(url, timeout=30)
            if response.status_code == 404:
                failed.append(f'GET {url!r} responded with HTTP {response.status_code!r}')
            elif response.status_code >= 400:
                suspicious.append(f'GET {url!r} responded with HTTP {response.status_code!r}')
        except requests.ConnectionError:
            suspicious.append(f'unable to connect to server: {url!r}')

    if failed:
        pytest.fail(', '.join(failed + suspicious))
    if suspicious:
        pytest.xfail(', '.join(suspicious))
