# -*- coding: utf-8 -*-

# pylint: disable=import-outside-toplevel,missing-function-docstring

# -----------------------------------------------------------------------------
# Copyright (c) 2016-2017 Anaconda, Inc.
#
# May be copied and distributed freely only as part of an Anaconda or
# Miniconda installation.
# -----------------------------------------------------------------------------

"""Tests for logger window."""

from __future__ import annotations

__all__ = ()

import logging
import os
from qtpy.QtCore import Qt
import pytest
from tests.current.widgets import common_extra


TEST_TEXT = 'WARNING TEST MESSAGE'
TEST_TEXT_EXTRA = 'SOMETHING ELSE'


@pytest.fixture(scope='function')
def loggerbot(qtbot, qt_styles, temporary_file):  # pylint: disable=redefined-outer-name,unused-argument
    from anaconda_navigator.utils import logs as utils_logs
    from anaconda_navigator.widgets.dialogs import logger as logger_dialogs

    temp_log_folder = os.path.dirname(temporary_file)
    temp_log_filename = os.path.basename(f'{temporary_file}.log')

    utils_logs.LOGGER_CONFIG.level = logging.WARNING
    utils_logs.LOGGER_CONFIG.file_path = os.path.join(temp_log_folder, temp_log_filename)

    utils_logs.setup_logger()

    utils_logs.logger.warning(TEST_TEXT)
    utils_logs.logger.warning(TEST_TEXT_EXTRA)

    widget = logger_dialogs.LogViewerDialog(log_folder=temp_log_folder, log_filename=temp_log_filename)
    qtbot.addWidget(widget)
    widget.show()
    return common_extra.BotContext(qtbot=qtbot, widget=widget)


def test_simple(loggerbot):  # pylint: disable=redefined-outer-name
    data = loggerbot.widget.row_data(0)
    message = data.get('message')

    assert loggerbot.widget.table_logs.rowCount() > 0
    assert TEST_TEXT in message


def test_search(loggerbot):  # pylint: disable=redefined-outer-name
    loggerbot.qtbot.keyClicks(loggerbot.widget.text_search, TEST_TEXT)

    assert loggerbot.widget.table_logs.isRowHidden(1)

    loggerbot.qtbot.keyClicks(loggerbot.widget.text_search, 'spam!')

    assert loggerbot.widget.table_logs.isRowHidden(0)
    assert loggerbot.widget.table_logs.isRowHidden(1)


def test_copy(loggerbot):  # pylint: disable=redefined-outer-name
    from qtpy.QtWidgets import QApplication  # pylint: disable=import-outside-toplevel
    app = QApplication.instance()

    loggerbot.qtbot.mouseClick(loggerbot.widget.button_copy, Qt.LeftButton)
    clipped = app.clipboard().text()

    assert TEST_TEXT in clipped
