# -*- coding: utf-8 -*-

# pylint: disable=import-outside-toplevel,missing-function-docstring

# -----------------------------------------------------------------------------
# Copyright (c) 2016-2017 Anaconda, Inc.
#
# May be copied and distributed freely only as part of an Anaconda or
# Miniconda installation.
# -----------------------------------------------------------------------------

"""Tests for update dialog."""

from __future__ import annotations

__all__ = ()

from qtpy.QtCore import Qt
import pytest
from tests.current.widgets import common_extra


@pytest.fixture(params=[False, True])
def updatedialog(qtbot, qt_styles, request):  # pylint: disable=unused-argument
    from anaconda_navigator.widgets.dialogs import update as update_dialogs

    widget = update_dialogs.DialogUpdateApplication('1.0', startup=request.param)
    qtbot.addWidget(widget)
    widget.show()
    return common_extra.BotContext(qtbot=qtbot, widget=widget)


def test_yes(updatedialog):  # pylint: disable=redefined-outer-name
    with updatedialog.qtbot.waitSignal(updatedialog.widget.accepted, timeout=1000, raising=True):
        updatedialog.qtbot.mouseClick(updatedialog.widget.button_yes, Qt.LeftButton)
    assert not updatedialog.widget.config.get('main', 'hide_update_dialog')


def test_no(updatedialog):  # pylint: disable=redefined-outer-name
    with updatedialog.qtbot.waitSignal(updatedialog.widget.rejected, timeout=1000, raising=True):
        updatedialog.qtbot.mouseClick(updatedialog.widget.button_no, Qt.LeftButton)
    assert not updatedialog.widget.config.get('main', 'hide_update_dialog')


def test_no_show(updatedialog):  # pylint: disable=redefined-outer-name
    with updatedialog.qtbot.waitSignal(updatedialog.widget.rejected, timeout=1000, raising=True):
        updatedialog.qtbot.mouseClick(updatedialog.widget.button_no_show, Qt.LeftButton)
    assert updatedialog.widget.config.get('main', 'hide_update_dialog')
