# -*- coding: utf-8 -*-

"""Helper utilities focused on interactions with functions."""

from __future__ import annotations

__all__ = ['extract_kwargs']

import typing
import inspect


def extract_kwargs(
        source: typing.MutableMapping[str, typing.Any],
        target: typing.Callable[..., typing.Any],
) -> typing.Mapping[str, typing.Any]:
    """Extract and remove kwargs from `source` that could be applied to `target` function."""
    return {
        key: source.pop(key)
        for key in inspect.signature(target).parameters
        if key in source
    }
