# -*- coding: utf-8 -*-

"""Additional tools for content iteration."""

from __future__ import annotations

__all__ = ['unique']

import typing


T = typing.TypeVar('T')


def unique(source: typing.Iterable[T]) -> typing.Iterator[T]:
    """Iterate through items and return only unique values."""
    item: T
    seen: typing.Set[T] = set()
    for item in source:
        if item in seen:
            continue
        seen.add(item)
        yield item
