# -*- coding: utf-8 -*-

# -----------------------------------------------------------------------------
# Copyright (c) 2016-2017 Anaconda, Inc.
#
# May be copied and distributed freely only as part of an Anaconda or
# Miniconda installation.
# -----------------------------------------------------------------------------

"""
This folder contains data files bundled with Anaconda Navigator package.

This folder is defined as a python module so that some convenience global variables can be defined.
"""

from __future__ import annotations

__all__ = [
    'CONF_METADATA_PATH', 'DATA_PATH',
    'APP_OVERRIDES_CONF_PATH', 'BASE_APPS_CONF_PATH', 'BUNDLE_METADATA_COMP_PATH', 'LINKS_INFO_PATH',
    'WHATS_NEW_EMPTY_PAGE',
]

import os
import typing

from anaconda_navigator.config import METADATA_PATH


CONF_METADATA_PATH: typing.Final[str] = os.path.join(METADATA_PATH, 'metadata.json')
DATA_PATH: typing.Final[str] = os.path.dirname(os.path.realpath(__file__))

APP_OVERRIDES_CONF_PATH: typing.Final[str] = os.path.join(DATA_PATH, 'app_overrides.yml')
BASE_APPS_CONF_PATH: typing.Final[str] = os.path.join(DATA_PATH, 'base_apps.yml')
BUNDLE_METADATA_COMP_PATH: typing.Final[str] = os.path.join(DATA_PATH, 'metadata.json.bz2')
LINKS_INFO_PATH: typing.Final[str] = os.path.join(DATA_PATH, 'links.json')
WHATS_NEW_EMPTY_PAGE: typing.Final[str] = os.path.join(DATA_PATH, 'whats_new_empty.html')
