# -*- coding: utf-8 -*-

"""Extra solvers to migrate anaconda.cloud related configs."""

from __future__ import annotations

__all__ = ()

from . import core


@core.CONFIGURATION_POOL.register
def migrate_cloud_base_url(context: core.ConfigurationContext) -> None:  # pylint: disable=unused-argument
    """Set a new base URL value."""
    context.config.remove_option('main', 'cloud_base_url')
    context.config.remove_option('main', 'advertisement_url')
    context.config.remove_option('internal', 'launchdarkly_proxy_base_url')
