from unittest.mock import patch

from repo_cli.commands.service_accounts import SubCommand


@patch("repo_cli.commands.base.SubCommandBase")
def test_list_tokens(mock_command_base, caplog):
    mock_command_base.api.get_service_tokens_for_channel.return_value = {
        "items": [
            {
                "id": "a2fde779-034f-4e1c-b9df-893952bf12ec",
                "name": "Token",
                "metadata": None,
                "type": "resource",
                "created_at": "2024-08-26T16:44:59.613123+00:00",
                "expires_at": "2024-09-25T00:00:00+00:00",
                "resources": [
                    {
                        "resource_type": "channel",
                        "resource_id": "channel",
                        "permission": "write",
                    }
                ],
            }
        ]
    }

    subcommand = SubCommand(mock_command_base)
    subcommand.list_tokens("channel", "user_id")

    assert "id" in caplog.records[0].message
    assert "a2fde779-034f-4e1c-b9df-893952bf12ec" in caplog.records[0].message
    mock_command_base.api.list_tokens.get_service_tokens_for_channel(
        "channel", "user_id"
    )
