from conda.plugins import CondaSubcommand, hookimpl

from repo_cli import commands
from repo_cli._version import get_versions
from repo_cli.commands.base import RepoCommand


def repo(args: list):
    main_cmd = RepoCommand(commands, args, get_versions())
    main_cmd.run()


@hookimpl
def conda_subcommands():
    yield CondaSubcommand(
        name="repo",
        summary="A subcommand that accesses PSM on-prem",
        action=repo,
    )
