import os
import platform
from ctypes import CDLL
from typing import List, Optional
from pathlib import Path

from .logger import logger


def find_library(path: Optional[str] = None, gpu: bool = False) -> str:
    system = platform.system()

    name = "ctransformers"
    if system == "Linux":
        name = f"lib{name}.so"
    elif system == "Windows":
        name = f"{name}.dll"
    elif system == "Darwin":
        name = f"lib{name}.dylib"
    else:
        name = ""

    return os.path.join(os.environ["CONDA_PREFIX"], "lib", name)


def load_cuda() -> bool:
    return True
