#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# dask-image documentation build configuration file, created by
# sphinx-quickstart on Tue Jul  9 22:26:36 2013.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import sys
import os

import dask_image._version

# Get the project root dir, which is the parent dir of this
cwd = os.getcwd()
project_root = os.path.dirname(cwd)

# Insert the project root dir as the first element in the PYTHONPATH.
# This lets us ensure that the source package is imported, and that its
# version is used.
sys.path.insert(0, project_root)

# -- General configuration ---------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.viewcode',
    'sphinx.ext.todo',
    'sphinx.ext.napoleon'
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'dask-image'
copyright = u"2018, John Kirkham"

# The version info for the project you're documenting, acts as replacement
# for |version| and |release|, also used in various other places throughout
# the built documents.
#
# The full version, including alpha/beta/rc tags.
release = dask_image._version.__version__
# The short X.Y.Z version.
version = '.'.join(release.split('.')[:3])
if "dev" in release:
    display_version = "(development version)"
else:
    display_version = version

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ['_build']


# -- Options for HTML output -------------------------------------------

# Set canonical URL from the Read the Docs Domain
html_baseurl = os.environ.get("READTHEDOCS_CANONICAL_URL", "")

# Tell Jinja2 templates the build is running on Read the Docs
if os.environ.get("READTHEDOCS", "") == "True":
    if "html_context" not in globals():
        html_context = {}
    html_context["READTHEDOCS"] = True

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = 'dask_sphinx_theme'

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
html_title = f"{project} {display_version} documentation"

# A shorter title for the navigation bar.  Default is the same as
# html_title.
html_short_title = f"{project} docs"

# Output file base name for HTML help builder.
htmlhelp_basename = 'dask_imagedoc'


# -- Options for LaTeX output ------------------------------------------

latex_elements = {}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass
# [howto/manual]).
latex_documents = [
    ('index', 'dask_image.tex',
     u'dask-image Documentation',
     u'John Kirkham', 'manual'),
]


# -- Options for manual page output ------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    ('index', 'dask_image',
     u'dask-image Documentation',
     [u'John Kirkham'], 1)
]


# -- Options for Texinfo output ----------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    ('index', 'dask_image',
     u'dask-image Documentation',
     u'John Kirkham',
     'dask_image',
     'One line description of project.',
     'Miscellaneous'),
]


# Run sphinx-apidoc before building docs.
def run_apidoc(_):
    ignore_paths = [
        "../setup.py",
        "../tests",
        "../travis_pypi_setup.py",
    ]

    argv = [
        "-f",
        "-T",
        "-e",
        "-M",
        "-o", ".",
        ".."
    ] + ignore_paths

    try:
        # Sphinx 1.7+
        from sphinx.ext import apidoc
    except ImportError:
        # Sphinx 1.6 (and earlier)
        from sphinx import apidoc
        argv.insert(0, apidoc.__file__)

    apidoc.main(argv)


def setup(app):
    app.connect('builder-inited', run_apidoc)
