# Building file on Windows

This guide outlines the steps to build file and libmagic on Windows using MSVC and `conda build`. It also provides
instructions for updating the build process for future versions of file. All CMakeLists.txt were based on ones found at
https://github.com/julian-r/file-windows.

---

## Updating for Future Versions

When new versions of file are released:

1. Check a diff between the last version we built and the latest release.
2. Update the CMake configuration:
   - The upstream `CMakeLists.txt` makes several file edits via concatenations. These have been converted into actual
   patch files in our build since we support that and it is a cleaner way to go about changing source files.
   - Source file lists in the CMake are typically identical to the lists found in each Makefile.am. For instance,
   `libmagic` is comprised of sources from the `LIBMAGIC_SOURCE_FILES` list and that list was populated from the 
   `libmagic_la_SOURCES` list found in `src/Makefile.am`.
   - Source files found in `WIN_COMPAT_SOURCES` are those that added to the `libmagic` output in order to complete the
   Windows build. They are not required for builds on other platforms.
   - In order to produce the `libmagic.lib` import library, a `magic.def` is provided and included in the
   `WIN_COMPAT_SOURCES`. This file tells CMake what symbols to export from `libmagic.dll` so that an import library is
   created.
   - Source for the `file.exe` binary can be found in that same Makefile under `file_SOURCES`.
   - The `windows-headers/unistd.h` header is provided to replicate some minor POSIX functionality on Windows. This
   should be updated as needed to support new features.
3. Update the `src/config.h.in`:
   - Check for new tests that need to be run. This project supplies a `src/config.h.in` which mirrors the one generated
   by an autotools build. A diff between the `config.h` generated by a `./configure` run and the one output by CMake
   can highlight header, library, and function call checks that need to be added or removed between versions. These
   checks can be found in the top-level `CMakeLists.txt`.

---

## Troubleshooting

- Missing Source Files: If the build fails due to missing files, ensure all new source files are included in
CMakeLists.txt.
- Test Failures: Check the test outputs against the updated source and adjust the CMake configuration as needed.
- Build Errors: Verify that all dependencies are correctly specified in meta.yaml and that the environment is properly
set up.
