Dask Examples
=============

This directory contains examples of machine learning workflows with LightGBM and [Dask](https://dask.org/).

Before running this code, see [the installation instructions for the Dask-package](https://github.com/microsoft/LightGBM/tree/master/python-package#install-dask-package).

After installing the package and its dependencies, any of the examples here can be run with a command like this:

```shell
python binary-classification.py
```

The examples listed below contain minimal code showing how to train LightGBM models using Dask.

**Training**

* [binary-classification.py](./binary-classification.py)
* [multiclass-classification.py](./multiclass-classification.py)
* [ranking.py](./ranking.py)
* [regression.py](./regression.py)

**Prediction**

* [prediction.py](./prediction.py)
