# coding: utf-8

"""
    external/v1/auth_service.proto

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: version not set
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    NOTE
    ----
    standard swagger-codegen-cli for this python client has been modified
    by custom templates. The purpose of these templates is to include
    typing information in the API and Model code. Please refer to the
    main grid repository for more info
"""

from __future__ import absolute_import

import re  # noqa: F401
from typing import TYPE_CHECKING, Any

# python 2 and python 3 compatibility library
import six

from lightning_cloud.openapi.api_client import ApiClient

if TYPE_CHECKING:
    from datetime import datetime
    from lightning_cloud.openapi.models import *

class BillingServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def billing_service_create_checkout_session(self, body: 'BillingCheckoutBody1', project_id: 'str', **kwargs) -> 'V1CreateCheckoutSessionResponse':  # noqa: E501
        """billing_service_create_checkout_session  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_create_checkout_session(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillingCheckoutBody1 body: (required)
        :param str project_id: (required)
        :return: V1CreateCheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.billing_service_create_checkout_session_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.billing_service_create_checkout_session_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def billing_service_create_checkout_session_with_http_info(self, body: 'BillingCheckoutBody1', project_id: 'str', **kwargs) -> 'V1CreateCheckoutSessionResponse':  # noqa: E501
        """billing_service_create_checkout_session  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_create_checkout_session_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillingCheckoutBody1 body: (required)
        :param str project_id: (required)
        :return: V1CreateCheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method billing_service_create_checkout_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `billing_service_create_checkout_session`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `billing_service_create_checkout_session`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId}/billing/checkout', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1CreateCheckoutSessionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def billing_service_create_org_checkout_session(self, body: 'BillingCheckoutBody', org_id: 'str', **kwargs) -> 'V1CreateCheckoutSessionResponse':  # noqa: E501
        """billing_service_create_org_checkout_session  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_create_org_checkout_session(body, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillingCheckoutBody body: (required)
        :param str org_id: (required)
        :return: V1CreateCheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.billing_service_create_org_checkout_session_with_http_info(body, org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.billing_service_create_org_checkout_session_with_http_info(body, org_id, **kwargs)  # noqa: E501
            return data

    def billing_service_create_org_checkout_session_with_http_info(self, body: 'BillingCheckoutBody', org_id: 'str', **kwargs) -> 'V1CreateCheckoutSessionResponse':  # noqa: E501
        """billing_service_create_org_checkout_session  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_create_org_checkout_session_with_http_info(body, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillingCheckoutBody body: (required)
        :param str org_id: (required)
        :return: V1CreateCheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method billing_service_create_org_checkout_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `billing_service_create_org_checkout_session`")  # noqa: E501
        # verify the required parameter 'org_id' is set
        if ('org_id' not in params or
                params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `billing_service_create_org_checkout_session`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_id' in params:
            path_params['orgId'] = params['org_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/{orgId}/billing/checkout', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1CreateCheckoutSessionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def billing_service_create_subscription_checkout_session(self, body: 'SubscriptionCheckoutBody', org_id: 'str', **kwargs) -> 'V1CreateSubscriptionCheckoutSessionResponse':  # noqa: E501
        """billing_service_create_subscription_checkout_session  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_create_subscription_checkout_session(body, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubscriptionCheckoutBody body: (required)
        :param str org_id: (required)
        :return: V1CreateSubscriptionCheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.billing_service_create_subscription_checkout_session_with_http_info(body, org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.billing_service_create_subscription_checkout_session_with_http_info(body, org_id, **kwargs)  # noqa: E501
            return data

    def billing_service_create_subscription_checkout_session_with_http_info(self, body: 'SubscriptionCheckoutBody', org_id: 'str', **kwargs) -> 'V1CreateSubscriptionCheckoutSessionResponse':  # noqa: E501
        """billing_service_create_subscription_checkout_session  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_create_subscription_checkout_session_with_http_info(body, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubscriptionCheckoutBody body: (required)
        :param str org_id: (required)
        :return: V1CreateSubscriptionCheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method billing_service_create_subscription_checkout_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `billing_service_create_subscription_checkout_session`")  # noqa: E501
        # verify the required parameter 'org_id' is set
        if ('org_id' not in params or
                params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `billing_service_create_subscription_checkout_session`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_id' in params:
            path_params['orgId'] = params['org_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/{orgId}/billing/subscription/checkout', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1CreateSubscriptionCheckoutSessionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def billing_service_get_billing_subscription(self, org_id: 'str', **kwargs) -> 'V1BillingSubscription':  # noqa: E501
        """Billing subscription endpoint that returns the organization's current subscription and its features  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_get_billing_subscription(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: (required)
        :return: V1BillingSubscription
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.billing_service_get_billing_subscription_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.billing_service_get_billing_subscription_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def billing_service_get_billing_subscription_with_http_info(self, org_id: 'str', **kwargs) -> 'V1BillingSubscription':  # noqa: E501
        """Billing subscription endpoint that returns the organization's current subscription and its features  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_get_billing_subscription_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: (required)
        :return: V1BillingSubscription
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method billing_service_get_billing_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in params or
                params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `billing_service_get_billing_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_id' in params:
            path_params['orgId'] = params['org_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/{orgId}/billing/subscription', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1BillingSubscription',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def billing_service_get_org_balance(self, org_id: 'str', **kwargs) -> 'V1GetProjectBalanceResponse':  # noqa: E501
        """billing_service_get_org_balance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_get_org_balance(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: (required)
        :return: V1GetProjectBalanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.billing_service_get_org_balance_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.billing_service_get_org_balance_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def billing_service_get_org_balance_with_http_info(self, org_id: 'str', **kwargs) -> 'V1GetProjectBalanceResponse':  # noqa: E501
        """billing_service_get_org_balance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_get_org_balance_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: (required)
        :return: V1GetProjectBalanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method billing_service_get_org_balance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in params or
                params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `billing_service_get_org_balance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_id' in params:
            path_params['orgId'] = params['org_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/{orgId}/billing/balance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1GetProjectBalanceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def billing_service_get_project_balance(self, project_id: 'str', **kwargs) -> 'V1GetProjectBalanceResponse':  # noqa: E501
        """billing_service_get_project_balance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_get_project_balance(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :return: V1GetProjectBalanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.billing_service_get_project_balance_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.billing_service_get_project_balance_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def billing_service_get_project_balance_with_http_info(self, project_id: 'str', **kwargs) -> 'V1GetProjectBalanceResponse':  # noqa: E501
        """billing_service_get_project_balance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_get_project_balance_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :return: V1GetProjectBalanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method billing_service_get_project_balance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `billing_service_get_project_balance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId}/billing/balance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1GetProjectBalanceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def billing_service_get_project_compute_usage(self, project_id: 'str', **kwargs) -> 'V1GetProjectComputeUsageResponse':  # noqa: E501
        """Compute usage, deprecate?  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_get_project_compute_usage(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :param datetime _from:
        :param datetime to:
        :param str resource_id:
        :return: V1GetProjectComputeUsageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.billing_service_get_project_compute_usage_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.billing_service_get_project_compute_usage_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def billing_service_get_project_compute_usage_with_http_info(self, project_id: 'str', **kwargs) -> 'V1GetProjectComputeUsageResponse':  # noqa: E501
        """Compute usage, deprecate?  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_get_project_compute_usage_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :param datetime _from:
        :param datetime to:
        :param str resource_id:
        :return: V1GetProjectComputeUsageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', '_from', 'to', 'resource_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method billing_service_get_project_compute_usage" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `billing_service_get_project_compute_usage`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []
        if '_from' in params:
            query_params.append(('from', params['_from']))  # noqa: E501
        if 'to' in params:
            query_params.append(('to', params['to']))  # noqa: E501
        if 'resource_id' in params:
            query_params.append(('resourceId', params['resource_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId}/billing/compute', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1GetProjectComputeUsageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def billing_service_get_usage_report(self, **kwargs) -> 'V1UsageReport':  # noqa: E501
        """Usage report endpoint to get credits spending information. Provides credits consumption data by particular project according to filters given.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_get_usage_report(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id:
        :param str project_id:
        :param str cluster_id:
        :param str resource_type:
        :param str resource_id:
        :param datetime _from:
        :param datetime to:
        :return: V1UsageReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.billing_service_get_usage_report_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.billing_service_get_usage_report_with_http_info(**kwargs)  # noqa: E501
            return data

    def billing_service_get_usage_report_with_http_info(self, **kwargs) -> 'V1UsageReport':  # noqa: E501
        """Usage report endpoint to get credits spending information. Provides credits consumption data by particular project according to filters given.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_get_usage_report_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id:
        :param str project_id:
        :param str cluster_id:
        :param str resource_type:
        :param str resource_id:
        :param datetime _from:
        :param datetime to:
        :return: V1UsageReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_id', 'project_id', 'cluster_id', 'resource_type', 'resource_id', '_from', 'to']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method billing_service_get_usage_report" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'org_id' in params:
            query_params.append(('orgId', params['org_id']))  # noqa: E501
        if 'project_id' in params:
            query_params.append(('projectId', params['project_id']))  # noqa: E501
        if 'cluster_id' in params:
            query_params.append(('clusterId', params['cluster_id']))  # noqa: E501
        if 'resource_type' in params:
            query_params.append(('resourceType', params['resource_type']))  # noqa: E501
        if 'resource_id' in params:
            query_params.append(('resourceId', params['resource_id']))  # noqa: E501
        if '_from' in params:
            query_params.append(('from', params['_from']))  # noqa: E501
        if 'to' in params:
            query_params.append(('to', params['to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/billing/usage-report', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1UsageReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def billing_service_quote_subscription(self, org_id: 'str', **kwargs) -> 'V1QuoteSubscriptionResponse':  # noqa: E501
        """billing_service_quote_subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_quote_subscription(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: (required)
        :param str product_id:
        :return: V1QuoteSubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.billing_service_quote_subscription_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.billing_service_quote_subscription_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def billing_service_quote_subscription_with_http_info(self, org_id: 'str', **kwargs) -> 'V1QuoteSubscriptionResponse':  # noqa: E501
        """billing_service_quote_subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_quote_subscription_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: (required)
        :param str product_id:
        :return: V1QuoteSubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_id', 'product_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method billing_service_quote_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in params or
                params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `billing_service_quote_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_id' in params:
            path_params['orgId'] = params['org_id']  # noqa: E501

        query_params = []
        if 'product_id' in params:
            query_params.append(('productId', params['product_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/{orgId}/billing/subscription/quote', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1QuoteSubscriptionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def billing_service_transfer_org_balance(self, body: 'BillingTransferBody', org_src_id: 'str', **kwargs) -> 'V1TransferOrgBalanceResponse':  # noqa: E501
        """Org wallet management  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_transfer_org_balance(body, org_src_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillingTransferBody body: (required)
        :param str org_src_id: (required)
        :return: V1TransferOrgBalanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.billing_service_transfer_org_balance_with_http_info(body, org_src_id, **kwargs)  # noqa: E501
        else:
            (data) = self.billing_service_transfer_org_balance_with_http_info(body, org_src_id, **kwargs)  # noqa: E501
            return data

    def billing_service_transfer_org_balance_with_http_info(self, body: 'BillingTransferBody', org_src_id: 'str', **kwargs) -> 'V1TransferOrgBalanceResponse':  # noqa: E501
        """Org wallet management  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_transfer_org_balance_with_http_info(body, org_src_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillingTransferBody body: (required)
        :param str org_src_id: (required)
        :return: V1TransferOrgBalanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'org_src_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method billing_service_transfer_org_balance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `billing_service_transfer_org_balance`")  # noqa: E501
        # verify the required parameter 'org_src_id' is set
        if ('org_src_id' not in params or
                params['org_src_id'] is None):
            raise ValueError("Missing the required parameter `org_src_id` when calling `billing_service_transfer_org_balance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_src_id' in params:
            path_params['orgSrcId'] = params['org_src_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/{orgSrcId}/billing/transfer', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1TransferOrgBalanceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def billing_service_transfer_project_balance(self, body: 'BillingTransferBody1', project_src_id: 'str', **kwargs) -> 'V1TransferProjectBalanceResponse':  # noqa: E501
        """Project wallet management  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_transfer_project_balance(body, project_src_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillingTransferBody1 body: (required)
        :param str project_src_id: (required)
        :return: V1TransferProjectBalanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.billing_service_transfer_project_balance_with_http_info(body, project_src_id, **kwargs)  # noqa: E501
        else:
            (data) = self.billing_service_transfer_project_balance_with_http_info(body, project_src_id, **kwargs)  # noqa: E501
            return data

    def billing_service_transfer_project_balance_with_http_info(self, body: 'BillingTransferBody1', project_src_id: 'str', **kwargs) -> 'V1TransferProjectBalanceResponse':  # noqa: E501
        """Project wallet management  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_transfer_project_balance_with_http_info(body, project_src_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillingTransferBody1 body: (required)
        :param str project_src_id: (required)
        :return: V1TransferProjectBalanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_src_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method billing_service_transfer_project_balance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `billing_service_transfer_project_balance`")  # noqa: E501
        # verify the required parameter 'project_src_id' is set
        if ('project_src_id' not in params or
                params['project_src_id'] is None):
            raise ValueError("Missing the required parameter `project_src_id` when calling `billing_service_transfer_project_balance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_src_id' in params:
            path_params['projectSrcId'] = params['project_src_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectSrcId}/billing/transfer', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1TransferProjectBalanceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def billing_service_update_billing_subscription(self, body: 'BillingSubscriptionBody', org_id: 'str', **kwargs) -> 'V1BillingSubscription':  # noqa: E501
        """billing_service_update_billing_subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_update_billing_subscription(body, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillingSubscriptionBody body: (required)
        :param str org_id: (required)
        :return: V1BillingSubscription
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.billing_service_update_billing_subscription_with_http_info(body, org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.billing_service_update_billing_subscription_with_http_info(body, org_id, **kwargs)  # noqa: E501
            return data

    def billing_service_update_billing_subscription_with_http_info(self, body: 'BillingSubscriptionBody', org_id: 'str', **kwargs) -> 'V1BillingSubscription':  # noqa: E501
        """billing_service_update_billing_subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_service_update_billing_subscription_with_http_info(body, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillingSubscriptionBody body: (required)
        :param str org_id: (required)
        :return: V1BillingSubscription
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method billing_service_update_billing_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `billing_service_update_billing_subscription`")  # noqa: E501
        # verify the required parameter 'org_id' is set
        if ('org_id' not in params or
                params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `billing_service_update_billing_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_id' in params:
            path_params['orgId'] = params['org_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/{orgId}/billing/subscription', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1BillingSubscription',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
