# coding: utf-8

"""
    external/v1/auth_service.proto

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: version not set
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    NOTE
    ----
    standard swagger-codegen-cli for this python client has been modified
    by custom templates. The purpose of these templates is to include
    typing information in the API and Model code. Please refer to the
    main grid repository for more info
"""

from __future__ import absolute_import

import re  # noqa: F401
from typing import TYPE_CHECKING, Any

# python 2 and python 3 compatibility library
import six

from lightning_cloud.openapi.api_client import ApiClient

if TYPE_CHECKING:
    from datetime import datetime
    from lightning_cloud.openapi.models import *

class SlurmJobsUserServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def slurm_jobs_user_service_create_user_slurm_job(self, body: 'SlurmJobsBody', project_id: 'str', **kwargs) -> 'V1SLURMJob':  # noqa: E501
        """CreateUserSLURMJob is used to create a new SLURM job for an authenticated user. For creating SLURM Jobs from an agent, please use the SLURMJobsAgentService.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slurm_jobs_user_service_create_user_slurm_job(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SlurmJobsBody body: (required)
        :param str project_id: (required)
        :return: V1SLURMJob
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slurm_jobs_user_service_create_user_slurm_job_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.slurm_jobs_user_service_create_user_slurm_job_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def slurm_jobs_user_service_create_user_slurm_job_with_http_info(self, body: 'SlurmJobsBody', project_id: 'str', **kwargs) -> 'V1SLURMJob':  # noqa: E501
        """CreateUserSLURMJob is used to create a new SLURM job for an authenticated user. For creating SLURM Jobs from an agent, please use the SLURMJobsAgentService.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slurm_jobs_user_service_create_user_slurm_job_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SlurmJobsBody body: (required)
        :param str project_id: (required)
        :return: V1SLURMJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slurm_jobs_user_service_create_user_slurm_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `slurm_jobs_user_service_create_user_slurm_job`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `slurm_jobs_user_service_create_user_slurm_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId}/slurm/jobs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1SLURMJob',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slurm_jobs_user_service_delete_user_slurm_job(self, project_id: 'str', id: 'str', **kwargs) -> 'V1DeleteUserSLURMJobResponse':  # noqa: E501
        """DeleteUserSLURMJob is used to delete a specific SLURM job for an authenticated user. For deleting SLURM Jobs from an agent, please use the SLURMJobsAgentService.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slurm_jobs_user_service_delete_user_slurm_job(project_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :param str id: (required)
        :return: V1DeleteUserSLURMJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slurm_jobs_user_service_delete_user_slurm_job_with_http_info(project_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.slurm_jobs_user_service_delete_user_slurm_job_with_http_info(project_id, id, **kwargs)  # noqa: E501
            return data

    def slurm_jobs_user_service_delete_user_slurm_job_with_http_info(self, project_id: 'str', id: 'str', **kwargs) -> 'V1DeleteUserSLURMJobResponse':  # noqa: E501
        """DeleteUserSLURMJob is used to delete a specific SLURM job for an authenticated user. For deleting SLURM Jobs from an agent, please use the SLURMJobsAgentService.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slurm_jobs_user_service_delete_user_slurm_job_with_http_info(project_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :param str id: (required)
        :return: V1DeleteUserSLURMJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slurm_jobs_user_service_delete_user_slurm_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `slurm_jobs_user_service_delete_user_slurm_job`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `slurm_jobs_user_service_delete_user_slurm_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId}/slurm/jobs/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1DeleteUserSLURMJobResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slurm_jobs_user_service_get_user_slurm_job(self, project_id: 'str', id: 'str', **kwargs) -> 'V1SLURMJob':  # noqa: E501
        """GetUserSLURMJob is used to get a specific SLURM job for an authenticated user. For getting SLURM Jobs from an agent, please use the SLURMJobsAgentService.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slurm_jobs_user_service_get_user_slurm_job(project_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :param str id: (required)
        :return: V1SLURMJob
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slurm_jobs_user_service_get_user_slurm_job_with_http_info(project_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.slurm_jobs_user_service_get_user_slurm_job_with_http_info(project_id, id, **kwargs)  # noqa: E501
            return data

    def slurm_jobs_user_service_get_user_slurm_job_with_http_info(self, project_id: 'str', id: 'str', **kwargs) -> 'V1SLURMJob':  # noqa: E501
        """GetUserSLURMJob is used to get a specific SLURM job for an authenticated user. For getting SLURM Jobs from an agent, please use the SLURMJobsAgentService.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slurm_jobs_user_service_get_user_slurm_job_with_http_info(project_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :param str id: (required)
        :return: V1SLURMJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slurm_jobs_user_service_get_user_slurm_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `slurm_jobs_user_service_get_user_slurm_job`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `slurm_jobs_user_service_get_user_slurm_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId}/slurm/jobs/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1SLURMJob',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slurm_jobs_user_service_get_user_slurm_job_logs(self, project_id: 'str', id: 'str', **kwargs) -> 'V1LogsResponse':  # noqa: E501
        """GetUserSLURMJobLogs is used to get the logs of a specific SLURM job for an authenticated user. For getting SLURM Job logs from an agent, please use the SLURMJobsAgentService.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slurm_jobs_user_service_get_user_slurm_job_logs(project_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :param str id: (required)
        :param str since:
        :param str until:
        :return: V1LogsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slurm_jobs_user_service_get_user_slurm_job_logs_with_http_info(project_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.slurm_jobs_user_service_get_user_slurm_job_logs_with_http_info(project_id, id, **kwargs)  # noqa: E501
            return data

    def slurm_jobs_user_service_get_user_slurm_job_logs_with_http_info(self, project_id: 'str', id: 'str', **kwargs) -> 'V1LogsResponse':  # noqa: E501
        """GetUserSLURMJobLogs is used to get the logs of a specific SLURM job for an authenticated user. For getting SLURM Job logs from an agent, please use the SLURMJobsAgentService.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slurm_jobs_user_service_get_user_slurm_job_logs_with_http_info(project_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :param str id: (required)
        :param str since:
        :param str until:
        :return: V1LogsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'id', 'since', 'until']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slurm_jobs_user_service_get_user_slurm_job_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `slurm_jobs_user_service_get_user_slurm_job_logs`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `slurm_jobs_user_service_get_user_slurm_job_logs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'since' in params:
            query_params.append(('since', params['since']))  # noqa: E501
        if 'until' in params:
            query_params.append(('until', params['until']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId}/slurm/jobs/{id}/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1LogsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slurm_jobs_user_service_list_user_slurm_jobs(self, project_id: 'str', **kwargs) -> 'V1ListUserSLURMJobsResponse':  # noqa: E501
        """ListUserSLURMJobs is used to list all SLURM jobs for an authenticated user. For listing SLURM Jobs from an agent, please use the SLURMJobsAgentService.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slurm_jobs_user_service_list_user_slurm_jobs(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :param list[str] cloudspace_ids: optional. if not provided, will list all jobs for the project in all cloudspaces.
        :param list[str] cluster_id_in:
        :param list[str] cluster_id_not_in:
        :param list[str] state_in:
        :return: V1ListUserSLURMJobsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slurm_jobs_user_service_list_user_slurm_jobs_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.slurm_jobs_user_service_list_user_slurm_jobs_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def slurm_jobs_user_service_list_user_slurm_jobs_with_http_info(self, project_id: 'str', **kwargs) -> 'V1ListUserSLURMJobsResponse':  # noqa: E501
        """ListUserSLURMJobs is used to list all SLURM jobs for an authenticated user. For listing SLURM Jobs from an agent, please use the SLURMJobsAgentService.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slurm_jobs_user_service_list_user_slurm_jobs_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :param list[str] cloudspace_ids: optional. if not provided, will list all jobs for the project in all cloudspaces.
        :param list[str] cluster_id_in:
        :param list[str] cluster_id_not_in:
        :param list[str] state_in:
        :return: V1ListUserSLURMJobsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'cloudspace_ids', 'cluster_id_in', 'cluster_id_not_in', 'state_in']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slurm_jobs_user_service_list_user_slurm_jobs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `slurm_jobs_user_service_list_user_slurm_jobs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []
        if 'cloudspace_ids' in params:
            query_params.append(('cloudspaceIds', params['cloudspace_ids']))  # noqa: E501
            collection_formats['cloudspaceIds'] = 'multi'  # noqa: E501
        if 'cluster_id_in' in params:
            query_params.append(('clusterIdIn', params['cluster_id_in']))  # noqa: E501
            collection_formats['clusterIdIn'] = 'multi'  # noqa: E501
        if 'cluster_id_not_in' in params:
            query_params.append(('clusterIdNotIn', params['cluster_id_not_in']))  # noqa: E501
            collection_formats['clusterIdNotIn'] = 'multi'  # noqa: E501
        if 'state_in' in params:
            query_params.append(('stateIn', params['state_in']))  # noqa: E501
            collection_formats['stateIn'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId}/slurm/jobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1ListUserSLURMJobsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slurm_jobs_user_service_update_user_slurm_job(self, body: 'JobsIdBody1', project_id: 'str', id: 'str', **kwargs) -> 'V1SLURMJob':  # noqa: E501
        """UpdateUserSLURMJob is used to update a specific SLURM job for an authenticated user. For updating SLURM Jobs from an agent, please use the SLURMJobsAgentService.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slurm_jobs_user_service_update_user_slurm_job(body, project_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param JobsIdBody1 body: (required)
        :param str project_id: (required)
        :param str id: (required)
        :return: V1SLURMJob
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slurm_jobs_user_service_update_user_slurm_job_with_http_info(body, project_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.slurm_jobs_user_service_update_user_slurm_job_with_http_info(body, project_id, id, **kwargs)  # noqa: E501
            return data

    def slurm_jobs_user_service_update_user_slurm_job_with_http_info(self, body: 'JobsIdBody1', project_id: 'str', id: 'str', **kwargs) -> 'V1SLURMJob':  # noqa: E501
        """UpdateUserSLURMJob is used to update a specific SLURM job for an authenticated user. For updating SLURM Jobs from an agent, please use the SLURMJobsAgentService.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slurm_jobs_user_service_update_user_slurm_job_with_http_info(body, project_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param JobsIdBody1 body: (required)
        :param str project_id: (required)
        :param str id: (required)
        :return: V1SLURMJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slurm_jobs_user_service_update_user_slurm_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `slurm_jobs_user_service_update_user_slurm_job`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `slurm_jobs_user_service_update_user_slurm_job`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `slurm_jobs_user_service_update_user_slurm_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId}/slurm/jobs/{id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1SLURMJob',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slurm_jobs_user_service_user_slurm_job_action(self, body: 'IdActionBody', project_id: 'str', id: 'str', **kwargs) -> 'V1UserSLURMJobActionResponse':  # noqa: E501
        """UserSLURMJobAction can be used to call an action on a specific SLURM job. For  example cancel the job.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slurm_jobs_user_service_user_slurm_job_action(body, project_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IdActionBody body: (required)
        :param str project_id: (required)
        :param str id: (required)
        :return: V1UserSLURMJobActionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slurm_jobs_user_service_user_slurm_job_action_with_http_info(body, project_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.slurm_jobs_user_service_user_slurm_job_action_with_http_info(body, project_id, id, **kwargs)  # noqa: E501
            return data

    def slurm_jobs_user_service_user_slurm_job_action_with_http_info(self, body: 'IdActionBody', project_id: 'str', id: 'str', **kwargs) -> 'V1UserSLURMJobActionResponse':  # noqa: E501
        """UserSLURMJobAction can be used to call an action on a specific SLURM job. For  example cancel the job.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slurm_jobs_user_service_user_slurm_job_action_with_http_info(body, project_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IdActionBody body: (required)
        :param str project_id: (required)
        :param str id: (required)
        :return: V1UserSLURMJobActionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slurm_jobs_user_service_user_slurm_job_action" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `slurm_jobs_user_service_user_slurm_job_action`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `slurm_jobs_user_service_user_slurm_job_action`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `slurm_jobs_user_service_user_slurm_job_action`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId}/slurm/jobs/{id}/action', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1UserSLURMJobActionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
