# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

import os
import re

import pytest

pytestmark = pytest.mark.nondestructive

LOG_REGEX = re.compile('<a class="text" href=".*" target="_blank">Driver Log</a>')


@pytest.mark.xfail(reason="Remote driver currently doesn't support logs")
def test_driver_log(testdir):
    testdir.makepyfile(
        """
        import pytest
        @pytest.mark.nondestructive
        def test_driver_log(webtext):
            assert False
    """
    )
    path = testdir.tmpdir.join("report.html")
    testdir.runpytestqa("--html", path)
    with open(str(path)) as f:
        html = f.read()

    assert LOG_REGEX.search(html) is not None
    log_path = testdir.tmpdir.dirpath("basetemp", "test_driver_log0", "driver.log")
    assert os.path.exists(str(log_path))


@pytest.mark.xfail(reason="Remote driver currently doesn't support logs")
def test_driver_log_fixture(testdir):
    file_test = testdir.makepyfile(
        """
        import pytest
        @pytest.fixture
        def driver_log():
            return 'foo.log'

        @pytest.mark.nondestructive
        def test_pass(webtext):
            assert webtext == u'Success!'
    """
    )
    testdir.quick_qa(file_test, passed=1)
    assert os.path.exists(str(testdir.tmpdir.join("foo.log")))


def test_no_driver_log(testdir):
    testdir.makepyfile(
        """
        import pytest
        @pytest.fixture
        def driver_log():
            return None

        @pytest.mark.nondestructive
        def test_no_driver_log(webtext):
            assert False
    """
    )
    path = testdir.tmpdir.join("report.html")
    testdir.runpytestqa("--html", path)
    with open(str(path)) as f:
        html = f.read()
    assert LOG_REGEX.search(html) is None
    log_path = testdir.tmpdir.dirpath("basetemp", "test_no_driver_log0", "driver.log")
    assert not os.path.exists(str(log_path))
