#include <QCoreApplication>
#include <QSvgGenerator>
#include <QBuffer>
#include <QDebug>

int main(int argc, char *argv[]) {
    // Initialize Qt Core Application for headless operation
    QCoreApplication app(argc, argv);
    
    qInfo() << "Testing Qt SVG functionality...";
    
    try {
        // Test 1: Create SVG generator and check version
        QSvgGenerator gen(QSvgGenerator::SvgVersion::Svg11);
        if (gen.svgVersion() != QSvgGenerator::SvgVersion::Svg11) {
            qFatal() << "Error: SVG generator version mismatch";
            return 1;
        }
        qInfo() << "✓ SVG generator version test passed";
        
        // Test 2: Try to create SVG content
        QBuffer buffer;
        buffer.open(QIODevice::WriteOnly);
        
        gen.setOutputDevice(&buffer);
        gen.setSize(QSize(100, 100));
        gen.setViewBox(QRect(0, 0, 100, 100));
        gen.setTitle("Test SVG");
        gen.setDescription("Test SVG generated by Qt");
        
        qInfo() << "✓ SVG generator configuration test passed";
        
        qInfo() << "All Qt SVG tests passed successfully!";
        return 0;
        
    } catch (const std::exception& e) {
        qFatal() << "Exception: " << e.what();
        return 1;
    } catch (...) {
        qFatal() << "Unknown exception occurred";
        return 1;
    }
}
