# This file is generated by SciPy's build process
# It contains system_info results at the time of building this package.
from enum import Enum

__all__ = ["show"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return { k: _cleanup(v) for k, v in d.items() if v != '' and _cleanup(v) != '' }
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "clang",
                "linker": r"ld64",
                "version": "17.0.6",
                "commands": r"arm64-apple-darwin20.0.0-clang",
                "args": r"-ftree-vectorize, -fPIC, -fstack-protector-strong, -O2, -pipe, -isystem, /var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/include, -fdebug-prefix-map=/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/work=/usr/local/src/conda/scipy-1.16.0, -fdebug-prefix-map=/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol=/usr/local/src/conda-prefix, -D_FORTIFY_SOURCE=2, -isystem, /var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/include, -mmacosx-version-min=11.1, -mmacosx-version-min=11.1",
                "linker args": r"-Wl,-headerpad_max_install_names, -Wl,-dead_strip_dylibs, -Wl,-rpath,/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/lib, -L/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/lib, -ftree-vectorize, -fPIC, -fstack-protector-strong, -O2, -pipe, -isystem, /var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/include, -fdebug-prefix-map=/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/work=/usr/local/src/conda/scipy-1.16.0, -fdebug-prefix-map=/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol=/usr/local/src/conda-prefix, -D_FORTIFY_SOURCE=2, -isystem, /var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/include, -mmacosx-version-min=11.1, -mmacosx-version-min=11.1",
            },
            "cython": {
                "name": r"cython",
                "linker": r"cython",
                "version": r"3.0.12",
                "commands": r"cython",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "clang",
                "linker": r"ld64",
                "version": "17.0.6",
                "commands": r"arm64-apple-darwin20.0.0-clang++",
                "args": r"-ftree-vectorize, -fPIC, -fstack-protector-strong, -O2, -pipe, -stdlib=libc++, -fvisibility-inlines-hidden, -fmessage-length=0, -isystem, /var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/include, -fdebug-prefix-map=/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/work=/usr/local/src/conda/scipy-1.16.0, -fdebug-prefix-map=/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol=/usr/local/src/conda-prefix, -D_FORTIFY_SOURCE=2, -isystem, /var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/include, -mmacosx-version-min=11.1, -mmacosx-version-min=11.1",
                "linker args": r"-Wl,-headerpad_max_install_names, -Wl,-dead_strip_dylibs, -Wl,-rpath,/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/lib, -L/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/lib, -ftree-vectorize, -fPIC, -fstack-protector-strong, -O2, -pipe, -stdlib=libc++, -fvisibility-inlines-hidden, -fmessage-length=0, -isystem, /var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/include, -fdebug-prefix-map=/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/work=/usr/local/src/conda/scipy-1.16.0, -fdebug-prefix-map=/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol=/usr/local/src/conda-prefix, -D_FORTIFY_SOURCE=2, -isystem, /var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/include, -mmacosx-version-min=11.1, -mmacosx-version-min=11.1",
            },
            "fortran": {
                "name": "gcc",
                "linker": r"ld64",
                "version": "11.2.0",
                "commands": r"/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_build_env/bin/arm64-apple-darwin20.0.0-gfortran",
                "args": r"-march=armv8-a, -ftree-vectorize, -fPIC, -fno-stack-protector, -O2, -pipe, -isystem, /var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/include, -fdebug-prefix-map=/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/work=/usr/local/src/conda/scipy-1.16.0, -fdebug-prefix-map=/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol=/usr/local/src/conda-prefix",
                "linker args": r"-Wl,-headerpad_max_install_names, -Wl,-dead_strip_dylibs, -Wl,-rpath,/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/lib, -L/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/lib, -march=armv8-a, -ftree-vectorize, -fPIC, -fno-stack-protector, -O2, -pipe, -isystem, /var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/include, -fdebug-prefix-map=/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/work=/usr/local/src/conda/scipy-1.16.0, -fdebug-prefix-map=/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol=/usr/local/src/conda-prefix",
            },
            "pythran": {
                "version": r"0.18.0",
                "include directory": r"../../../../../../../../../../../var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/lib/python3.11/site-packages/pythran"
            },
        },
        "Machine Information": {
            "host": {
                "cpu": r"aarch64",
                "family": r"aarch64",
                "endian": r"little",
                "system": r"darwin",
            },
            "build": {
                "cpu": r"aarch64",
                "family": r"aarch64",
                "endian": r"little",
                "system": r"darwin",
            },
            "cross-compiled": bool("False".lower().replace('false', '')),
        },
        "Build Dependencies": {
            "blas": {
                "name": "openblas",
                "found": bool("True".lower().replace('false', '')),
                "version": "0.3.29",
                "detection method": "pkgconfig",
                "include directory": r"/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/include",
                "lib directory": r"/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/lib",
                "openblas configuration": r"USE_64BITINT=0 DYNAMIC_ARCH=1 DYNAMIC_OLDER= NO_CBLAS= NO_LAPACK=0 NO_LAPACKE= NO_AFFINITY=1 USE_OPENMP=0 VORTEX MAX_THREADS=128",
                "pc file directory": r"/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/lib/pkgconfig",
            },
            "lapack": {
                "name": "openblas",
                "found": bool("True".lower().replace('false', '')),
                "version": "0.3.29",
                "detection method": "pkgconfig",
                "include directory": r"/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/include",
                "lib directory": r"/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/lib",
                "openblas configuration": r"USE_64BITINT=0 DYNAMIC_ARCH=1 DYNAMIC_OLDER= NO_CBLAS= NO_LAPACK=0 NO_LAPACKE= NO_AFFINITY=1 USE_OPENMP=0 VORTEX MAX_THREADS=128",
                "pc file directory": r"/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/lib/pkgconfig",
            },
            "pybind11": {
                "name": "pybind11",
                "version": "2.13.6",
                "detection method": "pkgconfig",
                "include directory": r"/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/include",
            },
        },
        "Python Information": {
            "path": r"/var/folders/nz/j6p8yfhx1mv_0grj5xl4650h0000gp/T/abs_2ftkv5if_0/croot/scipy_1755766518499/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehol/bin/python",
            "version": "3.11",
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which SciPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )
