"""
Snowflake API Integration API.

The Snowflake API Integration API is a REST API that you can use to access, update, and perform certain actions on API Integration resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from pydantic import StrictBool, StrictStr

from snowflake.core.api_integration._generated.models.api_hook import ApiHook


class GitHook(ApiHook):
    """A model object representing the GitHook resource.

    Constructs an object of type GitHook with the provided properties.

    Parameters
    __________
    allow_any_secret : bool,  default False
        Whether to allow any Snowflake secret when accessing the Git repository. This setting is ignored if allowed_authentication_secrets is present.
    allowed_authentication_secrets : list[str], optional
        A comma-separated list of fully-qualified Snowflake secret names that UDF or procedure handler code can use when accessing the Git repository.
    allowed_api_authentication_integrations : list[str], optional
        A comma-separated list of Snowflake security integration names that UDF or procedure handler code can use when accessing the Git repository. If empty, allow no integrations.
    """

    allow_any_secret: Optional[StrictBool] = False

    allowed_authentication_secrets: Optional[List[StrictStr]] = None

    allowed_api_authentication_integrations: Optional[List[StrictStr]] = None

    __properties = ["type"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GitHook:
        """Create an instance of GitHook from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # set to None if allowed_authentication_secrets (nullable) is None
        if self.allowed_authentication_secrets is None:
            _dict["allowed_authentication_secrets"] = None

        # set to None if allowed_api_authentication_integrations (nullable) is None
        if self.allowed_api_authentication_integrations is None:
            _dict["allowed_api_authentication_integrations"] = None

        _dict["type"] = ApiHook.get_child_model_discriminator_value("GitHook")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> GitHook:
        """Create an instance of GitHook from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return GitHook.parse_obj(obj)

        _obj = GitHook.parse_obj(
            {
                "allow_any_secret": obj.get("allow_any_secret") if obj.get("allow_any_secret") is not None else False,
                "allowed_authentication_secrets": obj.get("allowed_authentication_secrets"),
                "allowed_api_authentication_integrations": obj.get("allowed_api_authentication_integrations"),
            }
        )

        return _obj


class GitHookModel(ApiHook):
    def __init__(
        self,  # optional properties
        allow_any_secret: Optional[bool] = False,
        allowed_authentication_secrets: Optional[list[str]] = None,
        allowed_api_authentication_integrations: Optional[list[str]] = None,
    ):
        """A model object representing the GitHook resource.

        Constructs an object of type GitHook with the provided properties.

        Parameters
        __________
        allow_any_secret : bool,  default False
            Whether to allow any Snowflake secret when accessing the Git repository. This setting is ignored if allowed_authentication_secrets is present.
        allowed_authentication_secrets : list[str], optional
            A comma-separated list of fully-qualified Snowflake secret names that UDF or procedure handler code can use when accessing the Git repository.
        allowed_api_authentication_integrations : list[str], optional
            A comma-separated list of Snowflake security integration names that UDF or procedure handler code can use when accessing the Git repository. If empty, allow no integrations.
        """
        super().__init__()
        self.allow_any_secret = allow_any_secret
        self.allowed_authentication_secrets = allowed_authentication_secrets
        self.allowed_api_authentication_integrations = allowed_api_authentication_integrations

    __properties = ["type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return GitHook(
            allow_any_secret=self.allow_any_secret,
            allowed_authentication_secrets=self.allowed_authentication_secrets,
            allowed_api_authentication_integrations=self.allowed_api_authentication_integrations,
        )

    @classmethod
    def _from_model(cls, model) -> GitHookModel:
        return GitHookModel(
            allow_any_secret=model.allow_any_secret,
            allowed_authentication_secrets=model.allowed_authentication_secrets,
            allowed_api_authentication_integrations=model.allowed_api_authentication_integrations,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a GitHook.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the GitHook object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> GitHookModel:
        """Create an instance of GitHook from a dict.

        This method constructs a GitHook object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        GitHook
            A GitHook object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(GitHook.from_dict(obj))


GitHook._model_class = GitHookModel
