"""
Snowflake Catalog Integration API.

The Snowflake Catalog Integration API is a REST API that you can use to access, update, and perform certain actions on Catalog Integration resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from datetime import datetime
from typing import Any, Optional

from pydantic import BaseModel, Field, StrictBool, StrictStr, field_validator
from typing_extensions import Annotated

from snowflake.core.catalog_integration._generated.models.catalog import Catalog, CatalogModel


class CatalogIntegration(BaseModel):
    """A model object representing the CatalogIntegration resource.

    Constructs an object of type CatalogIntegration with the provided properties.

    Parameters
    __________
    name : str
        Name of the catalog integration.
    catalog : Catalog

    table_format : str
        Table format of the catalog.
    enabled : bool
        whether this catalog integration is available to use for Iceberg tables.
    comment : str, optional
        Comment.
    type : str, optional
        Type of the integration. Always CATALOG.
    category : str, optional
        Category of the integration. Always CATALOG.
    created_on : datetime, optional
        Date and time when the catalog integration was created.
    """

    name: Annotated[str, Field(strict=True)]

    catalog: Catalog

    table_format: StrictStr

    enabled: StrictBool

    comment: Optional[StrictStr] = None

    type: Optional[StrictStr] = None

    category: Optional[StrictStr] = None

    created_on: Optional[datetime] = None

    __properties = ["name", "catalog", "table_format", "enabled", "comment", "type", "category", "created_on"]

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("table_format")
    def table_format_validate_enum(cls, v):
        if v not in ("ICEBERG"):
            raise ValueError("must validate the enum values ('ICEBERG')")
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CatalogIntegration:
        """Create an instance of CatalogIntegration from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "type",
                    "category",
                    "created_on",
                }
            )

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of catalog
        if self.catalog:
            _dict["catalog"] = self.catalog.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> CatalogIntegration:
        """Create an instance of CatalogIntegration from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CatalogIntegration.parse_obj(obj)

        _obj = CatalogIntegration.parse_obj(
            {
                "name": obj.get("name"),
                "catalog": Catalog.from_dict(obj.get("catalog")) if obj.get("catalog") is not None else None,
                "table_format": obj.get("table_format"),
                "enabled": obj.get("enabled"),
                "comment": obj.get("comment"),
                "type": obj.get("type"),
                "category": obj.get("category"),
                "created_on": obj.get("created_on"),
            }
        )

        return _obj


class CatalogIntegrationModel:
    def __init__(
        self,
        name: str,
        catalog: Catalog,
        table_format: str,
        enabled: bool,
        # optional properties
        comment: Optional[str] = None,
        type: Optional[str] = None,
        category: Optional[str] = None,
        created_on: Optional[datetime] = None,
    ):
        """A model object representing the CatalogIntegration resource.

        Constructs an object of type CatalogIntegration with the provided properties.

        Parameters
        __________
        name : str
            Name of the catalog integration.
        catalog : Catalog

        table_format : str
            Table format of the catalog.
        enabled : bool
            whether this catalog integration is available to use for Iceberg tables.
        comment : str, optional
            Comment.
        type : str, optional
            Type of the integration. Always CATALOG.
        category : str, optional
            Category of the integration. Always CATALOG.
        created_on : datetime, optional
            Date and time when the catalog integration was created.
        """
        self.name = name
        self.catalog = catalog
        self.table_format = table_format
        self.enabled = enabled
        self.comment = comment
        self.type = type
        self.category = category
        self.created_on = created_on

    __properties = ["name", "catalog", "table_format", "enabled", "comment", "type", "category", "created_on"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return CatalogIntegration(
            name=self.name,
            catalog=self.catalog._to_model() if self.catalog is not None else None,
            table_format=self.table_format,
            enabled=self.enabled,
            comment=self.comment,
            type=self.type,
            category=self.category,
            created_on=self.created_on,
        )

    @classmethod
    def _from_model(cls, model) -> CatalogIntegrationModel:
        return CatalogIntegrationModel(
            name=model.name,
            catalog=CatalogModel._from_model(model.catalog) if model.catalog else None,
            table_format=model.table_format,
            enabled=model.enabled,
            comment=model.comment,
            type=model.type,
            category=model.category,
            created_on=model.created_on,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a CatalogIntegration.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the CatalogIntegration object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> CatalogIntegrationModel:
        """Create an instance of CatalogIntegration from a dict.

        This method constructs a CatalogIntegration object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        CatalogIntegration
            A CatalogIntegration object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(CatalogIntegration.from_dict(obj))


CatalogIntegration._model_class = CatalogIntegrationModel
