"""
Snowflake Catalog Integration API.

The Snowflake Catalog Integration API is a REST API that you can use to access, update, and perform certain actions on Catalog Integration resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any

from pydantic import StrictStr

from snowflake.core.catalog_integration._generated.models.catalog import Catalog
from snowflake.core.catalog_integration._generated.models.rest_authentication import (
    RestAuthentication,
    RestAuthenticationModel,
)
from snowflake.core.catalog_integration._generated.models.rest_config import RestConfig, RestConfigModel


class Polaris(Catalog):
    """A model object representing the Polaris resource.

    Constructs an object of type Polaris with the provided properties.

    Parameters
    __________
    catalog_namespace : str
        Default Polaris namespace used by all Iceberg tables associated with this catalog integration
    rest_config : RestConfig

    rest_authentication : RestAuthentication
    """

    catalog_namespace: StrictStr

    rest_config: RestConfig

    rest_authentication: RestAuthentication

    __properties = ["catalog_source"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Polaris:
        """Create an instance of Polaris from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of rest_config
        if self.rest_config:
            _dict["rest_config"] = self.rest_config.to_dict()

        # override the default output from pydantic by calling `to_dict()` of rest_authentication
        if self.rest_authentication:
            _dict["rest_authentication"] = self.rest_authentication.to_dict()

        _dict["catalog_source"] = Catalog.get_child_model_discriminator_value("Polaris")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Polaris:
        """Create an instance of Polaris from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Polaris.parse_obj(obj)

        _obj = Polaris.parse_obj(
            {
                "catalog_namespace": obj.get("catalog_namespace"),
                "rest_config": RestConfig.from_dict(obj.get("rest_config"))
                if obj.get("rest_config") is not None
                else None,
                "rest_authentication": RestAuthentication.from_dict(obj.get("rest_authentication"))
                if obj.get("rest_authentication") is not None
                else None,
            }
        )

        return _obj


class PolarisModel(Catalog):
    def __init__(
        self,
        catalog_namespace: str,
        rest_config: RestConfig,
        rest_authentication: RestAuthentication,
        # optional properties
    ):
        """A model object representing the Polaris resource.

        Constructs an object of type Polaris with the provided properties.

        Parameters
        __________
        catalog_namespace : str
            Default Polaris namespace used by all Iceberg tables associated with this catalog integration
        rest_config : RestConfig

        rest_authentication : RestAuthentication
        """
        super().__init__()
        self.catalog_namespace = catalog_namespace
        self.rest_config = rest_config
        self.rest_authentication = rest_authentication

    __properties = ["catalog_source"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Polaris(
            catalog_namespace=self.catalog_namespace,
            rest_config=self.rest_config._to_model() if self.rest_config is not None else None,
            rest_authentication=self.rest_authentication._to_model() if self.rest_authentication is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> PolarisModel:
        return PolarisModel(
            catalog_namespace=model.catalog_namespace,
            rest_config=RestConfigModel._from_model(model.rest_config) if model.rest_config else None,
            rest_authentication=RestAuthenticationModel._from_model(model.rest_authentication)
            if model.rest_authentication
            else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Polaris.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Polaris object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> PolarisModel:
        """Create an instance of Polaris from a dict.

        This method constructs a Polaris object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Polaris
            A Polaris object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Polaris.from_dict(obj))


Polaris._model_class = PolarisModel
