"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictStr

from snowflake.core.cortex.analyst_service._generated.models.agentic_optimization_status import (
    AgenticOptimizationStatus,
)


class AgenticOptimizationSummary(BaseModel):
    """A model object representing the AgenticOptimizationSummary resource.

    Constructs an object of type AgenticOptimizationSummary with the provided properties.

    Parameters
    __________
    optimization_name : str, optional
        The fully-qualified name of the optimization.
    status : AgenticOptimizationStatus, optional
    """

    optimization_name: Optional[StrictStr] = None

    status: Optional[AgenticOptimizationStatus] = None

    __properties = ["optimization_name", "status"]

    class Config:  # noqa: D106
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AgenticOptimizationSummary:
        """Create an instance of AgenticOptimizationSummary from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> AgenticOptimizationSummary:
        """Create an instance of AgenticOptimizationSummary from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AgenticOptimizationSummary.parse_obj(obj)

        _obj = AgenticOptimizationSummary.parse_obj(
            {
                "optimization_name": obj.get("optimization_name"),
                "status": obj.get("status"),
            }
        )

        return _obj


class AgenticOptimizationSummaryModel:
    def __init__(
        self,  # optional properties
        optimization_name: Optional[str] = None,
        status: Optional[AgenticOptimizationStatus] = None,
    ):
        """A model object representing the AgenticOptimizationSummary resource.

        Constructs an object of type AgenticOptimizationSummary with the provided properties.

        Parameters
        __________
        optimization_name : str, optional
            The fully-qualified name of the optimization.
        status : AgenticOptimizationStatus, optional
        """
        self.optimization_name = optimization_name
        self.status = status

    __properties = ["optimization_name", "status"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return AgenticOptimizationSummary(
            optimization_name=self.optimization_name,
            status=self.status,
        )

    @classmethod
    def _from_model(cls, model) -> AgenticOptimizationSummaryModel:
        return AgenticOptimizationSummaryModel(
            optimization_name=model.optimization_name,
            status=model.status,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a AgenticOptimizationSummary.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the AgenticOptimizationSummary object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> AgenticOptimizationSummaryModel:
        """Create an instance of AgenticOptimizationSummary from a dict.

        This method constructs a AgenticOptimizationSummary object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        AgenticOptimizationSummary
            A AgenticOptimizationSummary object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(AgenticOptimizationSummary.from_dict(obj))


AgenticOptimizationSummary._model_class = AgenticOptimizationSummaryModel
