"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel

from snowflake.core.cortex.analyst_service._generated.models.verified_query import VerifiedQuery, VerifiedQueryModel


class Confidence(BaseModel):
    """A model object representing the Confidence resource.

    Constructs an object of type Confidence with the provided properties.

    Parameters
    __________
    verified_query_used : VerifiedQuery, optional
    """

    verified_query_used: Optional[VerifiedQuery] = None

    __properties = ["verified_query_used"]

    class Config:  # noqa: D106
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Confidence:
        """Create an instance of Confidence from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of verified_query_used
        if self.verified_query_used:
            _dict["verified_query_used"] = self.verified_query_used.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Confidence:
        """Create an instance of Confidence from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Confidence.parse_obj(obj)

        _obj = Confidence.parse_obj(
            {
                "verified_query_used": VerifiedQuery.from_dict(obj.get("verified_query_used"))
                if obj.get("verified_query_used") is not None
                else None,
            }
        )

        return _obj


class ConfidenceModel:
    def __init__(
        self,  # optional properties
        verified_query_used: Optional[VerifiedQuery] = None,
    ):
        """A model object representing the Confidence resource.

        Constructs an object of type Confidence with the provided properties.

        Parameters
        __________
        verified_query_used : VerifiedQuery, optional
        """
        self.verified_query_used = verified_query_used

    __properties = ["verified_query_used"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Confidence(
            verified_query_used=self.verified_query_used._to_model() if self.verified_query_used is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> ConfidenceModel:
        return ConfidenceModel(
            verified_query_used=VerifiedQueryModel._from_model(model.verified_query_used)
            if model.verified_query_used
            else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Confidence.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Confidence object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ConfidenceModel:
        """Create an instance of Confidence from a dict.

        This method constructs a Confidence object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Confidence
            A Confidence object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Confidence.from_dict(obj))


Confidence._model_class = ConfidenceModel
