"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictStr

from snowflake.core.cortex.analyst_service._generated.models.semantic_model_object import (
    SemanticModelObject,
    SemanticModelObjectModel,
)


class CreateAgenticOptimizationRequest(BaseModel):
    """A model object representing the CreateAgenticOptimizationRequest resource.

    Constructs an object of type CreateAgenticOptimizationRequest with the provided properties.

    Parameters
    __________
    semantic_model : SemanticModelObject

    warehouse : str, optional
        Warehouse name to use for processing suggestions.
    experimental : str, optional
        JSON serialized string of experimental API fields (undocumented).
    """

    semantic_model: SemanticModelObject

    warehouse: Optional[StrictStr] = None

    experimental: Optional[StrictStr] = None

    __properties = ["semantic_model", "warehouse", "experimental"]

    class Config:  # noqa: D106
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateAgenticOptimizationRequest:
        """Create an instance of CreateAgenticOptimizationRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of semantic_model
        if self.semantic_model:
            _dict["semantic_model"] = self.semantic_model.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> CreateAgenticOptimizationRequest:
        """Create an instance of CreateAgenticOptimizationRequest from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CreateAgenticOptimizationRequest.parse_obj(obj)

        _obj = CreateAgenticOptimizationRequest.parse_obj(
            {
                "semantic_model": SemanticModelObject.from_dict(obj.get("semantic_model"))
                if obj.get("semantic_model") is not None
                else None,
                "warehouse": obj.get("warehouse"),
                "experimental": obj.get("experimental"),
            }
        )

        return _obj


class CreateAgenticOptimizationRequestModel:
    def __init__(
        self,
        semantic_model: SemanticModelObject,
        # optional properties
        warehouse: Optional[str] = None,
        experimental: Optional[str] = None,
    ):
        """A model object representing the CreateAgenticOptimizationRequest resource.

        Constructs an object of type CreateAgenticOptimizationRequest with the provided properties.

        Parameters
        __________
        semantic_model : SemanticModelObject

        warehouse : str, optional
            Warehouse name to use for processing suggestions.
        experimental : str, optional
            JSON serialized string of experimental API fields (undocumented).
        """
        self.semantic_model = semantic_model
        self.warehouse = warehouse
        self.experimental = experimental

    __properties = ["semantic_model", "warehouse", "experimental"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return CreateAgenticOptimizationRequest(
            semantic_model=self.semantic_model._to_model() if self.semantic_model is not None else None,
            warehouse=self.warehouse,
            experimental=self.experimental,
        )

    @classmethod
    def _from_model(cls, model) -> CreateAgenticOptimizationRequestModel:
        return CreateAgenticOptimizationRequestModel(
            semantic_model=SemanticModelObjectModel._from_model(model.semantic_model) if model.semantic_model else None,
            warehouse=model.warehouse,
            experimental=model.experimental,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a CreateAgenticOptimizationRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the CreateAgenticOptimizationRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> CreateAgenticOptimizationRequestModel:
        """Create an instance of CreateAgenticOptimizationRequest from a dict.

        This method constructs a CreateAgenticOptimizationRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        CreateAgenticOptimizationRequest
            A CreateAgenticOptimizationRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(CreateAgenticOptimizationRequest.from_dict(obj))


CreateAgenticOptimizationRequest._model_class = CreateAgenticOptimizationRequestModel
