"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Dict, Optional

from pydantic import BaseModel


class FastGenerationRequest(BaseModel):
    """A model object representing the FastGenerationRequest resource.

    Constructs an object of type FastGenerationRequest with the provided properties.

    Parameters
    __________
    json_proto : object, optional
        A JSON-mapped FastGenerationRequest protobuf
    """

    json_proto: Optional[Dict[str, Any]] = None

    __properties = ["json_proto"]

    class Config:  # noqa: D106
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FastGenerationRequest:
        """Create an instance of FastGenerationRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> FastGenerationRequest:
        """Create an instance of FastGenerationRequest from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return FastGenerationRequest.parse_obj(obj)

        _obj = FastGenerationRequest.parse_obj(
            {
                "json_proto": obj.get("json_proto"),
            }
        )

        return _obj


class FastGenerationRequestModel:
    def __init__(
        self,  # optional properties
        json_proto: Optional[object] = None,
    ):
        """A model object representing the FastGenerationRequest resource.

        Constructs an object of type FastGenerationRequest with the provided properties.

        Parameters
        __________
        json_proto : object, optional
            A JSON-mapped FastGenerationRequest protobuf
        """
        self.json_proto = json_proto

    __properties = ["json_proto"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return FastGenerationRequest(
            json_proto=self.json_proto,
        )

    @classmethod
    def _from_model(cls, model) -> FastGenerationRequestModel:
        return FastGenerationRequestModel(
            json_proto=model.json_proto,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a FastGenerationRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the FastGenerationRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> FastGenerationRequestModel:
        """Create an instance of FastGenerationRequest from a dict.

        This method constructs a FastGenerationRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        FastGenerationRequest
            A FastGenerationRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(FastGenerationRequest.from_dict(obj))


FastGenerationRequest._model_class = FastGenerationRequestModel
