"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from pydantic import BaseModel, StrictInt, StrictStr, field_validator

from snowflake.core.cortex.analyst_service._generated.models.semantic_model_object import (
    SemanticModelObject,
    SemanticModelObjectModel,
)
from snowflake.core.cortex.analyst_service._generated.models.sql_inputs import SqlInputs, SqlInputsModel
from snowflake.core.cortex.analyst_service._generated.models.table_columns import TableColumns, TableColumnsModel
from snowflake.core.cortex.analyst_service._generated.models.tds_input import TdsInput, TdsInputModel


class GenerateVerifiedQuerySuggestionsRequest(BaseModel):
    """A model object representing the GenerateVerifiedQuerySuggestionsRequest resource.

    Constructs an object of type GenerateVerifiedQuerySuggestionsRequest with the provided properties.

    Parameters
    __________
    warehouse : str
        Warehouse name to use for processing suggestions.
    mode : str,  default 'ca_requests_based'
        Whether to generate suggestions based on historical CA requests or all SQL queries. One of 'ca_requests_based' or 'query_history_based'
    semantic_model : SemanticModelObject, optional

    tables : list[TableColumns], optional

    tds_source : list[TdsInput], optional

    sql_source : SqlInputs, optional

    offset : int, optional
        The suggestions offset index, offset = 0 indicates the first call
    limit : int, optional
        The number of suggestions to return starting from the provided offset value
    experimental : str, optional
        JSON serialized string of experimental API fields (undocumented).
    """

    mode: Optional[StrictStr] = "ca_requests_based"

    semantic_model: Optional[SemanticModelObject] = None

    tables: Optional[List[TableColumns]] = None

    tds_source: Optional[List[TdsInput]] = None

    sql_source: Optional[SqlInputs] = None

    warehouse: StrictStr

    offset: Optional[StrictInt] = None

    limit: Optional[StrictInt] = None

    experimental: Optional[StrictStr] = None

    __properties = [
        "mode",
        "semantic_model",
        "tables",
        "tds_source",
        "sql_source",
        "warehouse",
        "offset",
        "limit",
        "experimental",
    ]

    @field_validator("mode")
    def mode_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ("ca_requests_based", "query_history_based"):
            raise ValueError("must validate the enum values ('ca_requests_based','query_history_based')")
        return v

    class Config:  # noqa: D106
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GenerateVerifiedQuerySuggestionsRequest:
        """Create an instance of GenerateVerifiedQuerySuggestionsRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of semantic_model
        if self.semantic_model:
            _dict["semantic_model"] = self.semantic_model.to_dict()

        # override the default output from pydantic by calling `to_dict()` of each item in tables (list)
        _items = []
        if self.tables:
            for _item in self.tables:
                if _item:
                    _items.append(_item.to_dict())
            _dict["tables"] = _items

        # override the default output from pydantic by calling `to_dict()` of each item in tds_source (list)
        _items = []
        if self.tds_source:
            for _item in self.tds_source:
                if _item:
                    _items.append(_item.to_dict())
            _dict["tds_source"] = _items

        # override the default output from pydantic by calling `to_dict()` of sql_source
        if self.sql_source:
            _dict["sql_source"] = self.sql_source.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> GenerateVerifiedQuerySuggestionsRequest:
        """Create an instance of GenerateVerifiedQuerySuggestionsRequest from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return GenerateVerifiedQuerySuggestionsRequest.parse_obj(obj)

        _obj = GenerateVerifiedQuerySuggestionsRequest.parse_obj(
            {
                "mode": obj.get("mode") if obj.get("mode") is not None else "ca_requests_based",
                "semantic_model": SemanticModelObject.from_dict(obj.get("semantic_model"))
                if obj.get("semantic_model") is not None
                else None,
                "tables": [TableColumns.from_dict(_item) for _item in obj.get("tables")]
                if obj.get("tables") is not None
                else None,
                "tds_source": [TdsInput.from_dict(_item) for _item in obj.get("tds_source")]
                if obj.get("tds_source") is not None
                else None,
                "sql_source": SqlInputs.from_dict(obj.get("sql_source")) if obj.get("sql_source") is not None else None,
                "warehouse": obj.get("warehouse"),
                "offset": obj.get("offset"),
                "limit": obj.get("limit"),
                "experimental": obj.get("experimental"),
            }
        )

        return _obj


class GenerateVerifiedQuerySuggestionsRequestModel:
    def __init__(
        self,
        warehouse: str,
        # optional properties
        mode: Optional[str] = "ca_requests_based",
        semantic_model: Optional[SemanticModelObject] = None,
        tables: Optional[list[TableColumns]] = None,
        tds_source: Optional[list[TdsInput]] = None,
        sql_source: Optional[SqlInputs] = None,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        experimental: Optional[str] = None,
    ):
        """A model object representing the GenerateVerifiedQuerySuggestionsRequest resource.

        Constructs an object of type GenerateVerifiedQuerySuggestionsRequest with the provided properties.

        Parameters
        __________
        warehouse : str
            Warehouse name to use for processing suggestions.
        mode : str,  default 'ca_requests_based'
            Whether to generate suggestions based on historical CA requests or all SQL queries. One of 'ca_requests_based' or 'query_history_based'
        semantic_model : SemanticModelObject, optional

        tables : list[TableColumns], optional

        tds_source : list[TdsInput], optional

        sql_source : SqlInputs, optional

        offset : int, optional
            The suggestions offset index, offset = 0 indicates the first call
        limit : int, optional
            The number of suggestions to return starting from the provided offset value
        experimental : str, optional
            JSON serialized string of experimental API fields (undocumented).
        """
        self.mode = mode
        self.semantic_model = semantic_model
        self.tables = tables
        self.tds_source = tds_source
        self.sql_source = sql_source
        self.warehouse = warehouse
        self.offset = offset
        self.limit = limit
        self.experimental = experimental

    __properties = [
        "mode",
        "semantic_model",
        "tables",
        "tds_source",
        "sql_source",
        "warehouse",
        "offset",
        "limit",
        "experimental",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return GenerateVerifiedQuerySuggestionsRequest(
            mode=self.mode,
            semantic_model=self.semantic_model._to_model() if self.semantic_model is not None else None,
            tables=[x._to_model() for x in self.tables] if self.tables is not None else None,
            tds_source=[x._to_model() for x in self.tds_source] if self.tds_source is not None else None,
            sql_source=self.sql_source._to_model() if self.sql_source is not None else None,
            warehouse=self.warehouse,
            offset=self.offset,
            limit=self.limit,
            experimental=self.experimental,
        )

    @classmethod
    def _from_model(cls, model) -> GenerateVerifiedQuerySuggestionsRequestModel:
        return GenerateVerifiedQuerySuggestionsRequestModel(
            mode=model.mode,
            semantic_model=SemanticModelObjectModel._from_model(model.semantic_model) if model.semantic_model else None,
            tables=[TableColumnsModel._from_model(x) for x in model.tables] if model.tables else None,
            tds_source=[TdsInputModel._from_model(x) for x in model.tds_source] if model.tds_source else None,
            sql_source=SqlInputsModel._from_model(model.sql_source) if model.sql_source else None,
            warehouse=model.warehouse,
            offset=model.offset,
            limit=model.limit,
            experimental=model.experimental,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a GenerateVerifiedQuerySuggestionsRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the GenerateVerifiedQuerySuggestionsRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> GenerateVerifiedQuerySuggestionsRequestModel:
        """Create an instance of GenerateVerifiedQuerySuggestionsRequest from a dict.

        This method constructs a GenerateVerifiedQuerySuggestionsRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        GenerateVerifiedQuerySuggestionsRequest
            A GenerateVerifiedQuerySuggestionsRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(GenerateVerifiedQuerySuggestionsRequest.from_dict(obj))


GenerateVerifiedQuerySuggestionsRequest._model_class = GenerateVerifiedQuerySuggestionsRequestModel
