"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictStr

from snowflake.core.cortex.analyst_service._generated.models.agentic_optimization_status import (
    AgenticOptimizationStatus,
)


class GetAgenticOptimizationResponse(BaseModel):
    """A model object representing the GetAgenticOptimizationResponse resource.

    Constructs an object of type GetAgenticOptimizationResponse with the provided properties.

    Parameters
    __________
    request_id : str, optional
        Unique request ID
    status : AgenticOptimizationStatus, optional

    state : str, optional
        An opaque string containing the state of the optimization.
    outcome : str, optional
        An opaque string containing the outcome of the optimization, separate from the state. This should be the JSON-encoded form of an AgenticOptimizationOutcome protobuf message.
    """

    request_id: Optional[StrictStr] = None

    status: Optional[AgenticOptimizationStatus] = None

    state: Optional[StrictStr] = None

    outcome: Optional[StrictStr] = None

    __properties = ["request_id", "status", "state", "outcome"]

    class Config:  # noqa: D106
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetAgenticOptimizationResponse:
        """Create an instance of GetAgenticOptimizationResponse from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> GetAgenticOptimizationResponse:
        """Create an instance of GetAgenticOptimizationResponse from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return GetAgenticOptimizationResponse.parse_obj(obj)

        _obj = GetAgenticOptimizationResponse.parse_obj(
            {
                "request_id": obj.get("request_id"),
                "status": obj.get("status"),
                "state": obj.get("state"),
                "outcome": obj.get("outcome"),
            }
        )

        return _obj


class GetAgenticOptimizationResponseModel:
    def __init__(
        self,  # optional properties
        request_id: Optional[str] = None,
        status: Optional[AgenticOptimizationStatus] = None,
        state: Optional[str] = None,
        outcome: Optional[str] = None,
    ):
        """A model object representing the GetAgenticOptimizationResponse resource.

        Constructs an object of type GetAgenticOptimizationResponse with the provided properties.

        Parameters
        __________
        request_id : str, optional
            Unique request ID
        status : AgenticOptimizationStatus, optional

        state : str, optional
            An opaque string containing the state of the optimization.
        outcome : str, optional
            An opaque string containing the outcome of the optimization, separate from the state. This should be the JSON-encoded form of an AgenticOptimizationOutcome protobuf message.
        """
        self.request_id = request_id
        self.status = status
        self.state = state
        self.outcome = outcome

    __properties = ["request_id", "status", "state", "outcome"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return GetAgenticOptimizationResponse(
            request_id=self.request_id,
            status=self.status,
            state=self.state,
            outcome=self.outcome,
        )

    @classmethod
    def _from_model(cls, model) -> GetAgenticOptimizationResponseModel:
        return GetAgenticOptimizationResponseModel(
            request_id=model.request_id,
            status=model.status,
            state=model.state,
            outcome=model.outcome,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a GetAgenticOptimizationResponse.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the GetAgenticOptimizationResponse object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> GetAgenticOptimizationResponseModel:
        """Create an instance of GetAgenticOptimizationResponse from a dict.

        This method constructs a GetAgenticOptimizationResponse object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        GetAgenticOptimizationResponse
            A GetAgenticOptimizationResponse object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(GetAgenticOptimizationResponse.from_dict(obj))


GetAgenticOptimizationResponse._model_class = GetAgenticOptimizationResponseModel
