"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from pydantic import BaseModel, StrictStr

from snowflake.core.cortex.analyst_service._generated.models.agentic_optimization_summary import (
    AgenticOptimizationSummary,
    AgenticOptimizationSummaryModel,
)


class ListAgenticOptimizationsResponse(BaseModel):
    """A model object representing the ListAgenticOptimizationsResponse resource.

    Constructs an object of type ListAgenticOptimizationsResponse with the provided properties.

    Parameters
    __________
    request_id : str, optional
        Unique request ID
    optimizations : list[AgenticOptimizationSummary], optional
    """

    request_id: Optional[StrictStr] = None

    optimizations: Optional[List[AgenticOptimizationSummary]] = None

    __properties = ["request_id", "optimizations"]

    class Config:  # noqa: D106
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ListAgenticOptimizationsResponse:
        """Create an instance of ListAgenticOptimizationsResponse from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of each item in optimizations (list)
        _items = []
        if self.optimizations:
            for _item in self.optimizations:
                if _item:
                    _items.append(_item.to_dict())
            _dict["optimizations"] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ListAgenticOptimizationsResponse:
        """Create an instance of ListAgenticOptimizationsResponse from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ListAgenticOptimizationsResponse.parse_obj(obj)

        _obj = ListAgenticOptimizationsResponse.parse_obj(
            {
                "request_id": obj.get("request_id"),
                "optimizations": [AgenticOptimizationSummary.from_dict(_item) for _item in obj.get("optimizations")]
                if obj.get("optimizations") is not None
                else None,
            }
        )

        return _obj


class ListAgenticOptimizationsResponseModel:
    def __init__(
        self,  # optional properties
        request_id: Optional[str] = None,
        optimizations: Optional[list[AgenticOptimizationSummary]] = None,
    ):
        """A model object representing the ListAgenticOptimizationsResponse resource.

        Constructs an object of type ListAgenticOptimizationsResponse with the provided properties.

        Parameters
        __________
        request_id : str, optional
            Unique request ID
        optimizations : list[AgenticOptimizationSummary], optional
        """
        self.request_id = request_id
        self.optimizations = optimizations

    __properties = ["request_id", "optimizations"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ListAgenticOptimizationsResponse(
            request_id=self.request_id,
            optimizations=[x._to_model() for x in self.optimizations] if self.optimizations is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> ListAgenticOptimizationsResponseModel:
        return ListAgenticOptimizationsResponseModel(
            request_id=model.request_id,
            optimizations=[AgenticOptimizationSummaryModel._from_model(x) for x in model.optimizations]
            if model.optimizations
            else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ListAgenticOptimizationsResponse.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ListAgenticOptimizationsResponse object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ListAgenticOptimizationsResponseModel:
        """Create an instance of ListAgenticOptimizationsResponse from a dict.

        This method constructs a ListAgenticOptimizationsResponse object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ListAgenticOptimizationsResponse
            A ListAgenticOptimizationsResponse object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ListAgenticOptimizationsResponse.from_dict(obj))


ListAgenticOptimizationsResponse._model_class = ListAgenticOptimizationsResponseModel
