"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from snowflake.core.cortex.analyst_service._generated.models.message_content_delta import (
    MessageContentDelta,
)
from snowflake.core.cortex.analyst_service._generated.models.suggestion_delta import (
    SuggestionDelta,
    SuggestionDeltaModel,
)


class MessageContentDeltaSuggestionsObject(MessageContentDelta):
    """A model object representing the MessageContentDeltaSuggestionsObject resource.

    Constructs an object of type MessageContentDeltaSuggestionsObject with the provided properties.

    Parameters
    __________
    suggestions_delta : SuggestionDelta

    index : int, optional
        The index of the content array this delta object represents
    """

    suggestions_delta: SuggestionDelta

    __properties = ["type", "index", "suggestions_delta"]

    class Config:  # noqa: D106
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MessageContentDeltaSuggestionsObject:
        """Create an instance of MessageContentDeltaSuggestionsObject from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of suggestions_delta
        if self.suggestions_delta:
            _dict["suggestions_delta"] = self.suggestions_delta.to_dict()

        _dict["type"] = MessageContentDelta.get_child_model_discriminator_value("MessageContentDeltaSuggestionsObject")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> MessageContentDeltaSuggestionsObject:
        """Create an instance of MessageContentDeltaSuggestionsObject from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return MessageContentDeltaSuggestionsObject.parse_obj(obj)

        _obj = MessageContentDeltaSuggestionsObject.parse_obj(
            {
                "index": obj.get("index"),
                "suggestions_delta": SuggestionDelta.from_dict(obj.get("suggestions_delta"))
                if obj.get("suggestions_delta") is not None
                else None,
            }
        )

        return _obj


class MessageContentDeltaSuggestionsObjectModel(MessageContentDelta):
    def __init__(
        self,
        suggestions_delta: SuggestionDelta,
        # optional properties
        index: Optional[int] = None,
    ):
        """A model object representing the MessageContentDeltaSuggestionsObject resource.

        Constructs an object of type MessageContentDeltaSuggestionsObject with the provided properties.

        Parameters
        __________
        suggestions_delta : SuggestionDelta

        index : int, optional
            The index of the content array this delta object represents
        """
        super().__init__(
            index=index,
        )
        self.suggestions_delta = suggestions_delta

    __properties = ["type", "index", "suggestions_delta"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return MessageContentDeltaSuggestionsObject(
            index=self.index,
            suggestions_delta=self.suggestions_delta._to_model() if self.suggestions_delta is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> MessageContentDeltaSuggestionsObjectModel:
        return MessageContentDeltaSuggestionsObjectModel(
            index=model.index,
            suggestions_delta=SuggestionDeltaModel._from_model(model.suggestions_delta)
            if model.suggestions_delta
            else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a MessageContentDeltaSuggestionsObject.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the MessageContentDeltaSuggestionsObject object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> MessageContentDeltaSuggestionsObjectModel:
        """Create an instance of MessageContentDeltaSuggestionsObject from a dict.

        This method constructs a MessageContentDeltaSuggestionsObject object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        MessageContentDeltaSuggestionsObject
            A MessageContentDeltaSuggestionsObject object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(MessageContentDeltaSuggestionsObject.from_dict(obj))


MessageContentDeltaSuggestionsObject._model_class = MessageContentDeltaSuggestionsObjectModel
