"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List

from pydantic import StrictStr

from snowflake.core.cortex.analyst_service._generated.models.message_content import MessageContent


class MessageContentSuggestionsObject(MessageContent):
    """A model object representing the MessageContentSuggestionsObject resource.

    Constructs an object of type MessageContentSuggestionsObject with the provided properties.

    Parameters
    __________
    suggestions : list[str]
    """

    suggestions: List[StrictStr]

    __properties = ["type", "suggestions"]

    class Config:  # noqa: D106
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MessageContentSuggestionsObject:
        """Create an instance of MessageContentSuggestionsObject from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        _dict["type"] = MessageContent.get_child_model_discriminator_value("MessageContentSuggestionsObject")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> MessageContentSuggestionsObject:
        """Create an instance of MessageContentSuggestionsObject from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return MessageContentSuggestionsObject.parse_obj(obj)

        _obj = MessageContentSuggestionsObject.parse_obj(
            {
                "suggestions": obj.get("suggestions"),
            }
        )

        return _obj


class MessageContentSuggestionsObjectModel(MessageContent):
    def __init__(
        self,
        suggestions: list[str],
        # optional properties
    ):
        """A model object representing the MessageContentSuggestionsObject resource.

        Constructs an object of type MessageContentSuggestionsObject with the provided properties.

        Parameters
        __________
        suggestions : list[str]
        """
        super().__init__()
        self.suggestions = suggestions

    __properties = ["type", "suggestions"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return MessageContentSuggestionsObject(
            suggestions=self.suggestions,
        )

    @classmethod
    def _from_model(cls, model) -> MessageContentSuggestionsObjectModel:
        return MessageContentSuggestionsObjectModel(
            suggestions=model.suggestions,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a MessageContentSuggestionsObject.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the MessageContentSuggestionsObject object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> MessageContentSuggestionsObjectModel:
        """Create an instance of MessageContentSuggestionsObject from a dict.

        This method constructs a MessageContentSuggestionsObject object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        MessageContentSuggestionsObject
            A MessageContentSuggestionsObject object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(MessageContentSuggestionsObject.from_dict(obj))


MessageContentSuggestionsObject._model_class = MessageContentSuggestionsObjectModel
