"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any

from pydantic import StrictStr

from snowflake.core.cortex.analyst_service._generated.models.message_content import MessageContent


class MessageContentTextObject(MessageContent):
    """A model object representing the MessageContentTextObject resource.

    Constructs an object of type MessageContentTextObject with the provided properties.

    Parameters
    __________
    text : str
    """

    text: StrictStr

    __properties = ["type", "text"]

    class Config:  # noqa: D106
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MessageContentTextObject:
        """Create an instance of MessageContentTextObject from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        _dict["type"] = MessageContent.get_child_model_discriminator_value("MessageContentTextObject")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> MessageContentTextObject:
        """Create an instance of MessageContentTextObject from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return MessageContentTextObject.parse_obj(obj)

        _obj = MessageContentTextObject.parse_obj(
            {
                "text": obj.get("text"),
            }
        )

        return _obj


class MessageContentTextObjectModel(MessageContent):
    def __init__(
        self,
        text: str,
        # optional properties
    ):
        """A model object representing the MessageContentTextObject resource.

        Constructs an object of type MessageContentTextObject with the provided properties.

        Parameters
        __________
        text : str
        """
        super().__init__()
        self.text = text

    __properties = ["type", "text"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return MessageContentTextObject(
            text=self.text,
        )

    @classmethod
    def _from_model(cls, model) -> MessageContentTextObjectModel:
        return MessageContentTextObjectModel(
            text=model.text,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a MessageContentTextObject.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the MessageContentTextObject object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> MessageContentTextObjectModel:
        """Create an instance of MessageContentTextObject from a dict.

        This method constructs a MessageContentTextObject object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        MessageContentTextObject
            A MessageContentTextObject object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(MessageContentTextObject.from_dict(obj))


MessageContentTextObject._model_class = MessageContentTextObjectModel
